/*****************************************************************************
-  \file : iap2_calculate_parameter_length.c
-  \version : $Id: iap2_calculate_parameter_length.c, v Exp $
-  \release : $Name:$
-  Contains the source code implementation for calculating the length of the parameter
-  \component :
-  \author : Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
-  \copyright (c) 2010 - 2016 Advanced Driver Information Technology.
-  This code is developed by Advanced Driver Information Technology.
-  Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
-  All rights reserved.
-  CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
-           DO NOT CHANGE THE CODE MANUALLY
*****************************************************************************/

#include "iap2_calculate_parameter_length.h"
#include "iap2_dlt_log.h"
#include "iap2_utility.h"

S32 iAP2CalcLengthiAP2AccessoryAuthenticationSerialNumberParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2AccessoryAuthenticationSerialNumberParameter* parameterStructure = (iAP2AccessoryAuthenticationSerialNumberParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AuthenticationSerialNumber_count < 1) || (parameterStructure->iAP2AuthenticationSerialNumber_count > 1) || 
            ( (parameterStructure->iAP2AuthenticationSerialNumber_count != 0) && (parameterStructure->iAP2AuthenticationSerialNumber == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AuthenticationSerialNumber: parameter_count = %d, parameterStructure->iAP2AuthenticationSerialNumber: %p",    \
                              parameterStructure->iAP2AuthenticationSerialNumber_count, parameterStructure->iAP2AuthenticationSerialNumber);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AuthenticationSerialNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2AuthenticationSerialNumber[element_loop]), parameterLength, parameterStructure->iAP2AuthenticationSerialNumber[element_loop].iAP2BlobLength);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2AuthenticationCertificateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2AuthenticationCertificateParameter* parameterStructure = (iAP2AuthenticationCertificateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AuthenticationCertificate_count < 1) || (parameterStructure->iAP2AuthenticationCertificate_count > 1) || 
            ( (parameterStructure->iAP2AuthenticationCertificate_count != 0) && (parameterStructure->iAP2AuthenticationCertificate == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AuthenticationCertificate: parameter_count = %d, parameterStructure->iAP2AuthenticationCertificate: %p",    \
                              parameterStructure->iAP2AuthenticationCertificate_count, parameterStructure->iAP2AuthenticationCertificate);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AuthenticationCertificate_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2AuthenticationCertificate[element_loop]), parameterLength, parameterStructure->iAP2AuthenticationCertificate[element_loop].iAP2BlobLength);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2AuthenticationResponseParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2AuthenticationResponseParameter* parameterStructure = (iAP2AuthenticationResponseParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AuthenticationResponse_count < 1) || (parameterStructure->iAP2AuthenticationResponse_count > 1) || 
            ( (parameterStructure->iAP2AuthenticationResponse_count != 0) && (parameterStructure->iAP2AuthenticationResponse == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AuthenticationResponse: parameter_count = %d, parameterStructure->iAP2AuthenticationResponse: %p",    \
                              parameterStructure->iAP2AuthenticationResponse_count, parameterStructure->iAP2AuthenticationResponse);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AuthenticationResponse_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2AuthenticationResponse[element_loop]), parameterLength, parameterStructure->iAP2AuthenticationResponse[element_loop].iAP2BlobLength);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2IdentificationInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2IdentificationInformationParameter* parameterStructure = (iAP2IdentificationInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AccessoryFirmwareVersion_count < 1) || (parameterStructure->iAP2AccessoryFirmwareVersion_count > 1) || 
            ( (parameterStructure->iAP2AccessoryFirmwareVersion_count != 0) && (parameterStructure->iAP2AccessoryFirmwareVersion == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryFirmwareVersion: parameter_count = %d, parameterStructure->iAP2AccessoryFirmwareVersion: %p",    \
                              parameterStructure->iAP2AccessoryFirmwareVersion_count, parameterStructure->iAP2AccessoryFirmwareVersion);
        }
        if( (parameterStructure->iAP2AccessoryHardwareVersion_count < 1) || (parameterStructure->iAP2AccessoryHardwareVersion_count > 1) || 
            ( (parameterStructure->iAP2AccessoryHardwareVersion_count != 0) && (parameterStructure->iAP2AccessoryHardwareVersion == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryHardwareVersion: parameter_count = %d, parameterStructure->iAP2AccessoryHardwareVersion: %p",    \
                              parameterStructure->iAP2AccessoryHardwareVersion_count, parameterStructure->iAP2AccessoryHardwareVersion);
        }
        if( (parameterStructure->iAP2AccessoryManufacturer_count < 1) || (parameterStructure->iAP2AccessoryManufacturer_count > 1) || 
            ( (parameterStructure->iAP2AccessoryManufacturer_count != 0) && (parameterStructure->iAP2AccessoryManufacturer == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryManufacturer: parameter_count = %d, parameterStructure->iAP2AccessoryManufacturer: %p",    \
                              parameterStructure->iAP2AccessoryManufacturer_count, parameterStructure->iAP2AccessoryManufacturer);
        }
        if( (parameterStructure->iAP2AccessoryModelIdentifier_count < 1) || (parameterStructure->iAP2AccessoryModelIdentifier_count > 1) || 
            ( (parameterStructure->iAP2AccessoryModelIdentifier_count != 0) && (parameterStructure->iAP2AccessoryModelIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryModelIdentifier: parameter_count = %d, parameterStructure->iAP2AccessoryModelIdentifier: %p",    \
                              parameterStructure->iAP2AccessoryModelIdentifier_count, parameterStructure->iAP2AccessoryModelIdentifier);
        }
        if( (parameterStructure->iAP2AccessoryName_count < 1) || (parameterStructure->iAP2AccessoryName_count > 1) || 
            ( (parameterStructure->iAP2AccessoryName_count != 0) && (parameterStructure->iAP2AccessoryName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryName: parameter_count = %d, parameterStructure->iAP2AccessoryName: %p",    \
                              parameterStructure->iAP2AccessoryName_count, parameterStructure->iAP2AccessoryName);
        }
        if( (parameterStructure->iAP2AccessorySerialNumber_count < 1) || (parameterStructure->iAP2AccessorySerialNumber_count > 1) || 
            ( (parameterStructure->iAP2AccessorySerialNumber_count != 0) && (parameterStructure->iAP2AccessorySerialNumber == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessorySerialNumber: parameter_count = %d, parameterStructure->iAP2AccessorySerialNumber: %p",    \
                              parameterStructure->iAP2AccessorySerialNumber_count, parameterStructure->iAP2AccessorySerialNumber);
        }
        if(parameterStructure->iAP2AppMatchTeamID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AppMatchTeamID: parameter_count = %d", parameterStructure->iAP2AppMatchTeamID_count);
        }
        if(parameterStructure->iAP2BluetoothHIDComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BluetoothHIDComponent: parameter_count = %d", parameterStructure->iAP2BluetoothHIDComponent_count);
        }
        if( (parameterStructure->iAP2CurrentLanguage_count < 1) || (parameterStructure->iAP2CurrentLanguage_count > 1) || 
            ( (parameterStructure->iAP2CurrentLanguage_count != 0) && (parameterStructure->iAP2CurrentLanguage == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CurrentLanguage: parameter_count = %d, parameterStructure->iAP2CurrentLanguage: %p",    \
                              parameterStructure->iAP2CurrentLanguage_count, parameterStructure->iAP2CurrentLanguage);
        }
        if(parameterStructure->iAP2LocationInformationComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponent: parameter_count = %d", parameterStructure->iAP2LocationInformationComponent_count);
        }
        if( (parameterStructure->iAP2MaximumCurrentDrawnFromDevice_count < 1) || (parameterStructure->iAP2MaximumCurrentDrawnFromDevice_count > 1) || 
            ( (parameterStructure->iAP2MaximumCurrentDrawnFromDevice_count != 0) && (parameterStructure->iAP2MaximumCurrentDrawnFromDevice == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaximumCurrentDrawnFromDevice: parameter_count = %d, parameterStructure->iAP2MaximumCurrentDrawnFromDevice: %p",    \
                              parameterStructure->iAP2MaximumCurrentDrawnFromDevice_count, parameterStructure->iAP2MaximumCurrentDrawnFromDevice);
        }
        if( (parameterStructure->iAP2MessagesRecievedfromDevice_count < 1) || (parameterStructure->iAP2MessagesRecievedfromDevice_count > 1) || 
            ( (parameterStructure->iAP2MessagesRecievedfromDevice_count != 0) && (parameterStructure->iAP2MessagesRecievedfromDevice == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MessagesRecievedfromDevice: parameter_count = %d, parameterStructure->iAP2MessagesRecievedfromDevice: %p",    \
                              parameterStructure->iAP2MessagesRecievedfromDevice_count, parameterStructure->iAP2MessagesRecievedfromDevice);
        }
        if( (parameterStructure->iAP2MessagesSentByAccessory_count < 1) || (parameterStructure->iAP2MessagesSentByAccessory_count > 1) || 
            ( (parameterStructure->iAP2MessagesSentByAccessory_count != 0) && (parameterStructure->iAP2MessagesSentByAccessory == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MessagesSentByAccessory: parameter_count = %d, parameterStructure->iAP2MessagesSentByAccessory: %p",    \
                              parameterStructure->iAP2MessagesSentByAccessory_count, parameterStructure->iAP2MessagesSentByAccessory);
        }
        if( (parameterStructure->iAP2PowerProvidingCapability_count < 1) || (parameterStructure->iAP2PowerProvidingCapability_count > 1) || 
            ( (parameterStructure->iAP2PowerProvidingCapability_count != 0) && (parameterStructure->iAP2PowerProvidingCapability == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PowerProvidingCapability: parameter_count = %d, parameterStructure->iAP2PowerProvidingCapability: %p",    \
                              parameterStructure->iAP2PowerProvidingCapability_count, parameterStructure->iAP2PowerProvidingCapability);
        }
        if(parameterStructure->iAP2SerialTransportComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2SerialTransportComponent: parameter_count = %d", parameterStructure->iAP2SerialTransportComponent_count);
        }
        if( (parameterStructure->iAP2SupportedLanguage_count < 1) || 
            ( (parameterStructure->iAP2SupportedLanguage_count != 0) && (parameterStructure->iAP2SupportedLanguage == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2SupportedLanguage: parameter_count = %d, parameterStructure->iAP2SupportedLanguage: %p",    \
                              parameterStructure->iAP2SupportedLanguage_count, parameterStructure->iAP2SupportedLanguage);
        }
        if(parameterStructure->iAP2USBDeviceTransportComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2USBDeviceTransportComponent: parameter_count = %d", parameterStructure->iAP2USBDeviceTransportComponent_count);
        }
        if(parameterStructure->iAP2USBHostTransportComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2USBHostTransportComponent: parameter_count = %d", parameterStructure->iAP2USBHostTransportComponent_count);
        }
        if(parameterStructure->iAP2VehicleInformationComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VehicleInformationComponent: parameter_count = %d", parameterStructure->iAP2VehicleInformationComponent_count);
        }
        if(parameterStructure->iAP2VehicleStatusComponent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VehicleStatusComponent: parameter_count = %d", parameterStructure->iAP2VehicleStatusComponent_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryFirmwareVersion_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryFirmwareVersion[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryHardwareVersion_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryHardwareVersion[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryManufacturer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryManufacturer[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryModelIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryModelIdentifier[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessorySerialNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessorySerialNumber[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AppMatchTeamID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AppMatchTeamID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothHIDComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2BluetoothHIDComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2BluetoothHIDComponent(&(parameterStructure->iAP2BluetoothHIDComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothTransportComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2BluetoothTransportComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2BluetoothTransportComponent(&(parameterStructure->iAP2BluetoothTransportComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CurrentLanguage_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2CurrentLanguage[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocol_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2ExternalAccessoryProtocol Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2ExternalAccessoryProtocol(&(parameterStructure->iAP2ExternalAccessoryProtocol[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2iAP2HIDComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2iAP2HIDComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2iAP2HIDComponent(&(parameterStructure->iAP2iAP2HIDComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2LocationInformationComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2LocationInformationComponent(&(parameterStructure->iAP2LocationInformationComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaximumCurrentDrawnFromDevice_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2MaximumCurrentDrawnFromDevice[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MessagesRecievedfromDevice_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2MessagesRecievedfromDevice[element_loop]), parameterLength, parameterStructure->iAP2MessagesRecievedfromDevice[element_loop].iAP2BlobLength);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MessagesSentByAccessory_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2MessagesSentByAccessory[element_loop]), parameterLength, parameterStructure->iAP2MessagesSentByAccessory[element_loop].iAP2BlobLength);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PowerProvidingCapability_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2PowerProvidingCapability[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2SerialTransportComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2SerialTransportComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2SerialTransportComponent(&(parameterStructure->iAP2SerialTransportComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2SupportedLanguage_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2SupportedLanguage[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBDeviceTransportComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2USBDeviceTransportComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2USBDeviceTransportComponent(&(parameterStructure->iAP2USBDeviceTransportComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBHostHIDComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2USBHostHIDComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2USBHostHIDComponent(&(parameterStructure->iAP2USBHostHIDComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBHostTransportComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2USBHostTransportComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2USBHostTransportComponent(&(parameterStructure->iAP2USBHostTransportComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VehicleInformationComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2VehicleInformationComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2VehicleInformationComponent(&(parameterStructure->iAP2VehicleInformationComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RouteGuidanceDisplayComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2RouteGuidanceDisplayComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2RouteGuidanceDisplayComponent(&(parameterStructure->iAP2RouteGuidanceDisplayComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VehicleStatusComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2VehicleStatusComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2VehicleStatusComponent(&(parameterStructure->iAP2VehicleStatusComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2WirelessCarPlayTransportComponent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2WirelessCarPlayTransportComponent Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2WirelessCarPlayTransportComponent(&(parameterStructure->iAP2WirelessCarPlayTransportComponent[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2IdentificationInformationUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2IdentificationInformationUpdateParameter* parameterStructure = (iAP2IdentificationInformationUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AccessoryFirmwareVersion_count < 1) || (parameterStructure->iAP2AccessoryFirmwareVersion_count > 1) || 
            ( (parameterStructure->iAP2AccessoryFirmwareVersion_count != 0) && (parameterStructure->iAP2AccessoryFirmwareVersion == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryFirmwareVersion: parameter_count = %d, parameterStructure->iAP2AccessoryFirmwareVersion: %p",    \
                              parameterStructure->iAP2AccessoryFirmwareVersion_count, parameterStructure->iAP2AccessoryFirmwareVersion);
        }
        if( (parameterStructure->iAP2AccessoryHardwareVersion_count < 1) || (parameterStructure->iAP2AccessoryHardwareVersion_count > 1) || 
            ( (parameterStructure->iAP2AccessoryHardwareVersion_count != 0) && (parameterStructure->iAP2AccessoryHardwareVersion == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryHardwareVersion: parameter_count = %d, parameterStructure->iAP2AccessoryHardwareVersion: %p",    \
                              parameterStructure->iAP2AccessoryHardwareVersion_count, parameterStructure->iAP2AccessoryHardwareVersion);
        }
        if( (parameterStructure->iAP2AccessoryManufacturer_count < 1) || (parameterStructure->iAP2AccessoryManufacturer_count > 1) || 
            ( (parameterStructure->iAP2AccessoryManufacturer_count != 0) && (parameterStructure->iAP2AccessoryManufacturer == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryManufacturer: parameter_count = %d, parameterStructure->iAP2AccessoryManufacturer: %p",    \
                              parameterStructure->iAP2AccessoryManufacturer_count, parameterStructure->iAP2AccessoryManufacturer);
        }
        if( (parameterStructure->iAP2AccessoryModelIdentifier_count < 1) || (parameterStructure->iAP2AccessoryModelIdentifier_count > 1) || 
            ( (parameterStructure->iAP2AccessoryModelIdentifier_count != 0) && (parameterStructure->iAP2AccessoryModelIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryModelIdentifier: parameter_count = %d, parameterStructure->iAP2AccessoryModelIdentifier: %p",    \
                              parameterStructure->iAP2AccessoryModelIdentifier_count, parameterStructure->iAP2AccessoryModelIdentifier);
        }
        if( (parameterStructure->iAP2AccessoryName_count < 1) || (parameterStructure->iAP2AccessoryName_count > 1) || 
            ( (parameterStructure->iAP2AccessoryName_count != 0) && (parameterStructure->iAP2AccessoryName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryName: parameter_count = %d, parameterStructure->iAP2AccessoryName: %p",    \
                              parameterStructure->iAP2AccessoryName_count, parameterStructure->iAP2AccessoryName);
        }
        if( (parameterStructure->iAP2AccessorySerialNumber_count < 1) || (parameterStructure->iAP2AccessorySerialNumber_count > 1) || 
            ( (parameterStructure->iAP2AccessorySerialNumber_count != 0) && (parameterStructure->iAP2AccessorySerialNumber == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessorySerialNumber: parameter_count = %d, parameterStructure->iAP2AccessorySerialNumber: %p",    \
                              parameterStructure->iAP2AccessorySerialNumber_count, parameterStructure->iAP2AccessorySerialNumber);
        }
        if( (parameterStructure->iAP2CurrentLanguage_count < 1) || (parameterStructure->iAP2CurrentLanguage_count > 1) || 
            ( (parameterStructure->iAP2CurrentLanguage_count != 0) && (parameterStructure->iAP2CurrentLanguage == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CurrentLanguage: parameter_count = %d, parameterStructure->iAP2CurrentLanguage: %p",    \
                              parameterStructure->iAP2CurrentLanguage_count, parameterStructure->iAP2CurrentLanguage);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryFirmwareVersion_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryFirmwareVersion[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryHardwareVersion_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryHardwareVersion[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryManufacturer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryManufacturer[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryModelIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryModelIdentifier[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessoryName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessorySerialNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AccessorySerialNumber[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CurrentLanguage_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2CurrentLanguage[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RequestAppLaunchParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RequestAppLaunchParameter* parameterStructure = (iAP2RequestAppLaunchParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AppBundleID_count < 1) || (parameterStructure->iAP2AppBundleID_count > 1) || 
            ( (parameterStructure->iAP2AppBundleID_count != 0) && (parameterStructure->iAP2AppBundleID == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AppBundleID: parameter_count = %d, parameterStructure->iAP2AppBundleID: %p",    \
                              parameterStructure->iAP2AppBundleID_count, parameterStructure->iAP2AppBundleID);
        }
        if(parameterStructure->iAP2LaunchAlert_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LaunchAlert: parameter_count = %d", parameterStructure->iAP2LaunchAlert_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AppBundleID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AppBundleID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LaunchAlert_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2LaunchAlert[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2OOBBTPairingAccessoryInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2OOBBTPairingAccessoryInformationParameter* parameterStructure = (iAP2OOBBTPairingAccessoryInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count < 1) || (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count != 0) && (parameterStructure->iAP2BluetoothTransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BluetoothTransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2BluetoothTransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2BluetoothTransportComponentIdentifier_count, parameterStructure->iAP2BluetoothTransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2DeviceClass_count < 1) || (parameterStructure->iAP2DeviceClass_count > 1) || 
            ( (parameterStructure->iAP2DeviceClass_count != 0) && (parameterStructure->iAP2DeviceClass == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DeviceClass: parameter_count = %d, parameterStructure->iAP2DeviceClass: %p",    \
                              parameterStructure->iAP2DeviceClass_count, parameterStructure->iAP2DeviceClass);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothTransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2BluetoothTransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DeviceClass_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->iAP2DeviceClass[element_loop]), parameterLength, sizeof(U32) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2OOBBTPairingCompletionInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2OOBBTPairingCompletionInformationParameter* parameterStructure = (iAP2OOBBTPairingCompletionInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2ResultCode_count < 1) || (parameterStructure->iAP2ResultCode_count > 1) || 
            ( (parameterStructure->iAP2ResultCode_count != 0) && (parameterStructure->iAP2ResultCode == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ResultCode: parameter_count = %d, parameterStructure->iAP2ResultCode: %p",    \
                              parameterStructure->iAP2ResultCode_count, parameterStructure->iAP2ResultCode);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ResultCode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2ResultCode[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartRouteGuidanceUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartRouteGuidanceUpdateParameter* parameterStructure = (iAP2StartRouteGuidanceUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RouteGuidanceDisplayComponentID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2RouteGuidanceDisplayComponentID[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StopRouteGuidanceUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StopRouteGuidanceUpdateParameter* parameterStructure = (iAP2StopRouteGuidanceUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RouteGuidanceDisplayComponentID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2RouteGuidanceDisplayComponentID[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2BluetoothComponentInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2BluetoothComponentInformationParameter* parameterStructure = (iAP2BluetoothComponentInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothComponentStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2BluetoothComponentStatus Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2BluetoothComponentStatus(&(parameterStructure->iAP2BluetoothComponentStatus[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartBluetoothConnectionUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartBluetoothConnectionUpdatesParameter* parameterStructure = (iAP2StartBluetoothConnectionUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count < 1) || 
            ( (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count != 0) && (parameterStructure->iAP2BluetoothTransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BluetoothTransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2BluetoothTransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2BluetoothTransportComponentIdentifier_count, parameterStructure->iAP2BluetoothTransportComponentIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothTransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2BluetoothTransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2AcceptCallParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2AcceptCallParameter* parameterStructure = (iAP2AcceptCallParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2AcceptAction_count < 1) || (parameterStructure->iAP2AcceptAction_count > 1) || 
            ( (parameterStructure->iAP2AcceptAction_count != 0) && (parameterStructure->iAP2AcceptAction == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AcceptAction: parameter_count = %d, parameterStructure->iAP2AcceptAction: %p",    \
                              parameterStructure->iAP2AcceptAction_count, parameterStructure->iAP2AcceptAction);
        }
        if(parameterStructure->iAP2CallUUID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CallUUID: parameter_count = %d", parameterStructure->iAP2CallUUID_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AcceptAction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2AcceptAction[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CallUUID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2CallUUID[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2EndCallParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2EndCallParameter* parameterStructure = (iAP2EndCallParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2CallUUID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CallUUID: parameter_count = %d", parameterStructure->iAP2CallUUID_count);
        }
        if( (parameterStructure->iAP2EndAction_count < 1) || (parameterStructure->iAP2EndAction_count > 1) || 
            ( (parameterStructure->iAP2EndAction_count != 0) && (parameterStructure->iAP2EndAction == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2EndAction: parameter_count = %d, parameterStructure->iAP2EndAction: %p",    \
                              parameterStructure->iAP2EndAction_count, parameterStructure->iAP2EndAction);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CallUUID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2CallUUID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2EndAction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2EndAction[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2HoldStatusUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2HoldStatusUpdateParameter* parameterStructure = (iAP2HoldStatusUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2CallUUID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CallUUID: parameter_count = %d", parameterStructure->iAP2CallUUID_count);
        }
        if( (parameterStructure->iAP2HoldStatusUpdate_count < 1) || (parameterStructure->iAP2HoldStatusUpdate_count > 1) || 
            ( (parameterStructure->iAP2HoldStatusUpdate_count != 0) && (parameterStructure->iAP2HoldStatusUpdate == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HoldStatusUpdate: parameter_count = %d, parameterStructure->iAP2HoldStatusUpdate: %p",    \
                              parameterStructure->iAP2HoldStatusUpdate_count, parameterStructure->iAP2HoldStatusUpdate);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CallUUID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2CallUUID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HoldStatusUpdate_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2HoldStatusUpdate[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2InitiateCallParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2InitiateCallParameter* parameterStructure = (iAP2InitiateCallParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AddressBookID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AddressBookID: parameter_count = %d", parameterStructure->iAP2AddressBookID_count);
        }
        if(parameterStructure->iAP2DestinationID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DestinationID: parameter_count = %d", parameterStructure->iAP2DestinationID_count);
        }
        if(parameterStructure->iAP2Service_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Service: parameter_count = %d", parameterStructure->iAP2Service_count);
        }
        if( (parameterStructure->iAP2Type_count < 1) || (parameterStructure->iAP2Type_count > 1) || 
            ( (parameterStructure->iAP2Type_count != 0) && (parameterStructure->iAP2Type == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Type: parameter_count = %d, parameterStructure->iAP2Type: %p",    \
                              parameterStructure->iAP2Type_count, parameterStructure->iAP2Type);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AddressBookID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2AddressBookID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DestinationID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2DestinationID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Service_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2Service[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Type_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2Type[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2MuteStatusUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2MuteStatusUpdateParameter* parameterStructure = (iAP2MuteStatusUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2MuteStatus_count < 1) || (parameterStructure->iAP2MuteStatus_count > 1) || 
            ( (parameterStructure->iAP2MuteStatus_count != 0) && (parameterStructure->iAP2MuteStatus == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MuteStatus: parameter_count = %d, parameterStructure->iAP2MuteStatus: %p",    \
                              parameterStructure->iAP2MuteStatus_count, parameterStructure->iAP2MuteStatus);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MuteStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2MuteStatus[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2SendDTMFParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2SendDTMFParameter* parameterStructure = (iAP2SendDTMFParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2CallUUID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CallUUID: parameter_count = %d", parameterStructure->iAP2CallUUID_count);
        }
        if( (parameterStructure->iAP2Tone_count < 1) || (parameterStructure->iAP2Tone_count > 1) || 
            ( (parameterStructure->iAP2Tone_count != 0) && (parameterStructure->iAP2Tone == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Tone: parameter_count = %d, parameterStructure->iAP2Tone: %p",    \
                              parameterStructure->iAP2Tone_count, parameterStructure->iAP2Tone);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CallUUID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2CallUUID[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Tone_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2Tone[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartCallStateUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartCallStateUpdatesParameter* parameterStructure = (iAP2StartCallStateUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AddressBookID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AddressBookID: parameter_count = %d", parameterStructure->iAP2AddressBookID_count);
        }
        if((parameterStructure->iAP2CallUUID_count < 1) || (parameterStructure->iAP2CallUUID_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CallUUID: parameter_count = %d, parameterStructure->iAP2CallUUID: %p",    \
                              parameterStructure->iAP2CallUUID_count, parameterStructure->iAP2CallUUID);
        }
        if((parameterStructure->iAP2ConferenceGroup_count < 1) || (parameterStructure->iAP2ConferenceGroup_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ConferenceGroup: parameter_count = %d, parameterStructure->iAP2ConferenceGroup: %p",    \
                              parameterStructure->iAP2ConferenceGroup_count, parameterStructure->iAP2ConferenceGroup);
        }
        if((parameterStructure->iAP2Direction_count < 1) || (parameterStructure->iAP2Direction_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Direction: parameter_count = %d, parameterStructure->iAP2Direction: %p",    \
                              parameterStructure->iAP2Direction_count, parameterStructure->iAP2Direction);
        }
        if(parameterStructure->iAP2DisconnectReason_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DisconnectReason: parameter_count = %d", parameterStructure->iAP2DisconnectReason_count);
        }
        if((parameterStructure->iAP2DisplayName_count < 1) || (parameterStructure->iAP2DisplayName_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DisplayName: parameter_count = %d, parameterStructure->iAP2DisplayName: %p",    \
                              parameterStructure->iAP2DisplayName_count, parameterStructure->iAP2DisplayName);
        }
        if((parameterStructure->iAP2IsConferenced_count < 1) || (parameterStructure->iAP2IsConferenced_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2IsConferenced: parameter_count = %d, parameterStructure->iAP2IsConferenced: %p",    \
                              parameterStructure->iAP2IsConferenced_count, parameterStructure->iAP2IsConferenced);
        }
        if(parameterStructure->iAP2Label_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Label: parameter_count = %d", parameterStructure->iAP2Label_count);
        }
        if((parameterStructure->iAP2RemoteID_count < 1) || (parameterStructure->iAP2RemoteID_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RemoteID: parameter_count = %d, parameterStructure->iAP2RemoteID: %p",    \
                              parameterStructure->iAP2RemoteID_count, parameterStructure->iAP2RemoteID);
        }
        if((parameterStructure->iAP2Service_count < 1) || (parameterStructure->iAP2Service_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Service: parameter_count = %d, parameterStructure->iAP2Service: %p",    \
                              parameterStructure->iAP2Service_count, parameterStructure->iAP2Service);
        }
        if((parameterStructure->iAP2Status_count < 1) || (parameterStructure->iAP2Status_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Status: parameter_count = %d, parameterStructure->iAP2Status: %p",    \
                              parameterStructure->iAP2Status_count, parameterStructure->iAP2Status);
        }
        if(parameterStructure->iAP2StartTimestamp_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2StartTimestamp: parameter_count = %d", parameterStructure->iAP2StartTimestamp_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AddressBookID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CallUUID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ConferenceGroup_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Direction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DisconnectReason_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DisplayName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2IsConferenced_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Label_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RemoteID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Service_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Status_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2StartTimestamp_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartCommunicationsUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartCommunicationsUpdatesParameter* parameterStructure = (iAP2StartCommunicationsUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AirplaneModeStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AirplaneModeStatus: parameter_count = %d", parameterStructure->iAP2AirplaneModeStatus_count);
        }
        if(parameterStructure->iAP2CarrierName_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CarrierName: parameter_count = %d", parameterStructure->iAP2CarrierName_count);
        }
        if(parameterStructure->iAP2CellularSupported_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CellularSupported: parameter_count = %d", parameterStructure->iAP2CellularSupported_count);
        }
        if(parameterStructure->iAP2CurrentCallCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CurrentCallCount: parameter_count = %d", parameterStructure->iAP2CurrentCallCount_count);
        }
        if(parameterStructure->iAP2EndAndAcceptAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2EndAndAcceptAvailable: parameter_count = %d", parameterStructure->iAP2EndAndAcceptAvailable_count);
        }
        if(parameterStructure->iAP2FaceTimeAudioEnabled_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2FaceTimeAudioEnabled: parameter_count = %d", parameterStructure->iAP2FaceTimeAudioEnabled_count);
        }
        if(parameterStructure->iAP2FaceTimeVideoEnabled_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2FaceTimeVideoEnabled: parameter_count = %d", parameterStructure->iAP2FaceTimeVideoEnabled_count);
        }
        if(parameterStructure->iAP2HoldAndAcceptAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HoldAndAcceptAvailable: parameter_count = %d", parameterStructure->iAP2HoldAndAcceptAvailable_count);
        }
        if(parameterStructure->iAP2HoldAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HoldAvailable: parameter_count = %d", parameterStructure->iAP2HoldAvailable_count);
        }
        if(parameterStructure->iAP2InitiateCallAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2InitiateCallAvailable: parameter_count = %d", parameterStructure->iAP2InitiateCallAvailable_count);
        }
        if(parameterStructure->iAP2MergeAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MergeAvailable: parameter_count = %d", parameterStructure->iAP2MergeAvailable_count);
        }
        if(parameterStructure->iAP2MuteStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MuteStatus: parameter_count = %d", parameterStructure->iAP2MuteStatus_count);
        }
        if(parameterStructure->iAP2NewVoiceMailCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2NewVoiceMailCount: parameter_count = %d", parameterStructure->iAP2NewVoiceMailCount_count);
        }
        if(parameterStructure->iAP2RegistrationStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RegistrationStatus: parameter_count = %d", parameterStructure->iAP2RegistrationStatus_count);
        }
        if(parameterStructure->iAP2SignalStrength_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2SignalStrength: parameter_count = %d", parameterStructure->iAP2SignalStrength_count);
        }
        if(parameterStructure->iAP2SwapAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2SwapAvailable: parameter_count = %d", parameterStructure->iAP2SwapAvailable_count);
        }
        if(parameterStructure->iAP2TelephonyEnabled_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TelephonyEnabled: parameter_count = %d", parameterStructure->iAP2TelephonyEnabled_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AirplaneModeStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CarrierName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CellularSupported_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CurrentCallCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2EndAndAcceptAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2FaceTimeAudioEnabled_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2FaceTimeVideoEnabled_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HoldAndAcceptAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HoldAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2InitiateCallAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MergeAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MuteStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2NewVoiceMailCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RegistrationStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2SignalStrength_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2SwapAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TelephonyEnabled_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartListUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartListUpdatesParameter* parameterStructure = (iAP2StartListUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2FavoritesListMax_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2FavoritesListMax: parameter_count = %d", parameterStructure->iAP2FavoritesListMax_count);
        }
        if(parameterStructure->iAP2FavoritesListProperties_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2FavoritesListProperties: parameter_count = %d", parameterStructure->iAP2FavoritesListProperties_count);
        }
        if(parameterStructure->iAP2RecentListCombine_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RecentListCombine: parameter_count = %d", parameterStructure->iAP2RecentListCombine_count);
        }
        if(parameterStructure->iAP2RecentListProperties_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RecentListProperties: parameter_count = %d", parameterStructure->iAP2RecentListProperties_count);
        }
        if(parameterStructure->iAP2RecentsListMax_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RecentsListMax: parameter_count = %d", parameterStructure->iAP2RecentsListMax_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2FavoritesListMax_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2FavoritesListMax[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2FavoritesListProperties_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2FavoritesListProperties Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2FavoritesListProperties(&(parameterStructure->iAP2FavoritesListProperties[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RecentListCombine_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2RecentListCombine[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RecentListProperties_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2RecentListProperties Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2RecentsListProperties(&(parameterStructure->iAP2RecentListProperties[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RecentsListMax_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2RecentsListMax[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RequestDeviceAuthenticationChallengeResponseParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RequestDeviceAuthenticationChallengeResponseParameter* parameterStructure = (iAP2RequestDeviceAuthenticationChallengeResponseParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2DeviceAuthenticationChallenge_count < 1) || (parameterStructure->iAP2DeviceAuthenticationChallenge_count > 1) || 
            ( (parameterStructure->iAP2DeviceAuthenticationChallenge_count != 0) && (parameterStructure->iAP2DeviceAuthenticationChallenge == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DeviceAuthenticationChallenge: parameter_count = %d, parameterStructure->iAP2DeviceAuthenticationChallenge: %p",    \
                              parameterStructure->iAP2DeviceAuthenticationChallenge_count, parameterStructure->iAP2DeviceAuthenticationChallenge);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DeviceAuthenticationChallenge_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2DeviceAuthenticationChallenge[element_loop]), parameterLength, parameterStructure->iAP2DeviceAuthenticationChallenge[element_loop].iAP2BlobLength);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StatusExternalAccessoryProtocolSessionParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StatusExternalAccessoryProtocolSessionParameter* parameterStructure = (iAP2StatusExternalAccessoryProtocolSessionParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier_count < 1) || (parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier_count > 1) || 
            ( (parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier_count != 0) && (parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ExternalAccessoryProtocolSessionIdentifier: parameter_count = %d, parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier: %p",    \
                              parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier_count, parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier);
        }
        if( (parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus_count < 1) || (parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus_count > 1) || 
            ( (parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus_count != 0) && (parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ExternalAccessoryProtocolSessionStatus: parameter_count = %d, parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus: %p",    \
                              parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus_count, parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2AccessoryHIDReportParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2AccessoryHIDReportParameter* parameterStructure = (iAP2AccessoryHIDReportParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2HIDComponentIdentifier_count < 1) || (parameterStructure->iAP2HIDComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentIdentifier_count != 0) && (parameterStructure->iAP2HIDComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentIdentifier: parameter_count = %d, parameterStructure->iAP2HIDComponentIdentifier: %p",    \
                              parameterStructure->iAP2HIDComponentIdentifier_count, parameterStructure->iAP2HIDComponentIdentifier);
        }
        if( (parameterStructure->iAP2HIDReport_count < 1) || (parameterStructure->iAP2HIDReport_count > 1) || 
            ( (parameterStructure->iAP2HIDReport_count != 0) && (parameterStructure->iAP2HIDReport == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDReport: parameter_count = %d, parameterStructure->iAP2HIDReport: %p",    \
                              parameterStructure->iAP2HIDReport_count, parameterStructure->iAP2HIDReport);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2HIDComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDReport_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2HIDReport[element_loop]), parameterLength, parameterStructure->iAP2HIDReport[element_loop].iAP2BlobLength);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartHIDParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartHIDParameter* parameterStructure = (iAP2StartHIDParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2HIDComponentIdentifier_count < 1) || (parameterStructure->iAP2HIDComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentIdentifier_count != 0) && (parameterStructure->iAP2HIDComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentIdentifier: parameter_count = %d, parameterStructure->iAP2HIDComponentIdentifier: %p",    \
                              parameterStructure->iAP2HIDComponentIdentifier_count, parameterStructure->iAP2HIDComponentIdentifier);
        }
        if( (parameterStructure->iAP2HIDReportDescriptor_count < 1) || (parameterStructure->iAP2HIDReportDescriptor_count > 1) || 
            ( (parameterStructure->iAP2HIDReportDescriptor_count != 0) && (parameterStructure->iAP2HIDReportDescriptor == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDReportDescriptor: parameter_count = %d, parameterStructure->iAP2HIDReportDescriptor: %p",    \
                              parameterStructure->iAP2HIDReportDescriptor_count, parameterStructure->iAP2HIDReportDescriptor);
        }
        if(parameterStructure->iAP2LocalizedKeyboardCountryCode_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocalizedKeyboardCountryCode: parameter_count = %d", parameterStructure->iAP2LocalizedKeyboardCountryCode_count);
        }
        if( (parameterStructure->iAP2ProductIdentifier_count < 1) || (parameterStructure->iAP2ProductIdentifier_count > 1) || 
            ( (parameterStructure->iAP2ProductIdentifier_count != 0) && (parameterStructure->iAP2ProductIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ProductIdentifier: parameter_count = %d, parameterStructure->iAP2ProductIdentifier: %p",    \
                              parameterStructure->iAP2ProductIdentifier_count, parameterStructure->iAP2ProductIdentifier);
        }
        if( (parameterStructure->iAP2VendorIdentifier_count < 1) || (parameterStructure->iAP2VendorIdentifier_count > 1) || 
            ( (parameterStructure->iAP2VendorIdentifier_count != 0) && (parameterStructure->iAP2VendorIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VendorIdentifier: parameter_count = %d, parameterStructure->iAP2VendorIdentifier: %p",    \
                              parameterStructure->iAP2VendorIdentifier_count, parameterStructure->iAP2VendorIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2HIDComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDReportDescriptor_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2HIDReportDescriptor[element_loop]), parameterLength, parameterStructure->iAP2HIDReportDescriptor[element_loop].iAP2BlobLength);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocalizedKeyboardCountryCode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2LocalizedKeyboardCountryCode[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ProductIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2ProductIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VendorIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2VendorIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StopHIDParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StopHIDParameter* parameterStructure = (iAP2StopHIDParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2HIDComponentIdentifier_count < 1) || (parameterStructure->iAP2HIDComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentIdentifier_count != 0) && (parameterStructure->iAP2HIDComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentIdentifier: parameter_count = %d, parameterStructure->iAP2HIDComponentIdentifier: %p",    \
                              parameterStructure->iAP2HIDComponentIdentifier_count, parameterStructure->iAP2HIDComponentIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2HIDComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2LocationInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2LocationInformationParameter* parameterStructure = (iAP2LocationInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2NMEASentence_count < 1) || 
            ( (parameterStructure->iAP2NMEASentence_count != 0) && (parameterStructure->iAP2NMEASentence == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2NMEASentence: parameter_count = %d, parameterStructure->iAP2NMEASentence: %p",    \
                              parameterStructure->iAP2NMEASentence_count, parameterStructure->iAP2NMEASentence);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2NMEASentence_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2NMEASentence[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2PlayMediaLibraryCollectionParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2PlayMediaLibraryCollectionParameter* parameterStructure = (iAP2PlayMediaLibraryCollectionParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2CollectionPersistentIdentifier_count < 1) || (parameterStructure->iAP2CollectionPersistentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2CollectionPersistentIdentifier_count != 0) && (parameterStructure->iAP2CollectionPersistentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CollectionPersistentIdentifier: parameter_count = %d, parameterStructure->iAP2CollectionPersistentIdentifier: %p",    \
                              parameterStructure->iAP2CollectionPersistentIdentifier_count, parameterStructure->iAP2CollectionPersistentIdentifier);
        }
        if(parameterStructure->iAP2CollectionStartingIndex_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CollectionStartingIndex: parameter_count = %d", parameterStructure->iAP2CollectionStartingIndex_count);
        }
        if( (parameterStructure->iAP2CollectionType_count < 1) || (parameterStructure->iAP2CollectionType_count > 1) || 
            ( (parameterStructure->iAP2CollectionType_count != 0) && (parameterStructure->iAP2CollectionType == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CollectionType: parameter_count = %d, parameterStructure->iAP2CollectionType: %p",    \
                              parameterStructure->iAP2CollectionType_count, parameterStructure->iAP2CollectionType);
        }
        if( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count < 1) || (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count > 1) || 
            ( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count != 0) && (parameterStructure->iAP2MediaLibraryUniqueIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaLibraryUniqueIdentifier: parameter_count = %d, parameterStructure->iAP2MediaLibraryUniqueIdentifier: %p",    \
                              parameterStructure->iAP2MediaLibraryUniqueIdentifier_count, parameterStructure->iAP2MediaLibraryUniqueIdentifier);
        }
        if(parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2StartingMediaItemPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CollectionPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint64, &(parameterStructure->iAP2CollectionPersistentIdentifier[element_loop]), parameterLength, sizeof(U64) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CollectionStartingIndex_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->iAP2CollectionStartingIndex[element_loop]), parameterLength, sizeof(U32) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CollectionType_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2CollectionType[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2MediaLibraryUniqueIdentifier[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint64, &(parameterStructure->iAP2StartingMediaItemPersistentIdentifier[element_loop]), parameterLength, sizeof(U64) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2PlayMediaLibraryCurrentSelectionParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2PlayMediaLibraryCurrentSelectionParameter* parameterStructure = (iAP2PlayMediaLibraryCurrentSelectionParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->MediaLibraryUniqueIdentifier_count < 1) || (parameterStructure->MediaLibraryUniqueIdentifier_count > 1) || 
            ( (parameterStructure->MediaLibraryUniqueIdentifier_count != 0) && (parameterStructure->MediaLibraryUniqueIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of MediaLibraryUniqueIdentifier: parameter_count = %d, parameterStructure->MediaLibraryUniqueIdentifier: %p",    \
                              parameterStructure->MediaLibraryUniqueIdentifier_count, parameterStructure->MediaLibraryUniqueIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->MediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->MediaLibraryUniqueIdentifier[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2PlayMediaLibraryItemsParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2PlayMediaLibraryItemsParameter* parameterStructure = (iAP2PlayMediaLibraryItemsParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2ItemsPersistentIdentifiers_count < 1) || (parameterStructure->iAP2ItemsPersistentIdentifiers_count > 1) || 
            ( (parameterStructure->iAP2ItemsPersistentIdentifiers_count != 0) && (parameterStructure->iAP2ItemsPersistentIdentifiers == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ItemsPersistentIdentifiers: parameter_count = %d, parameterStructure->iAP2ItemsPersistentIdentifiers: %p",    \
                              parameterStructure->iAP2ItemsPersistentIdentifiers_count, parameterStructure->iAP2ItemsPersistentIdentifiers);
        }
        if(parameterStructure->ItemsStartingIndex_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of ItemsStartingIndex: parameter_count = %d", parameterStructure->ItemsStartingIndex_count);
        }
        if( (parameterStructure->MediaLibraryUniqueIdentifier_count < 1) || (parameterStructure->MediaLibraryUniqueIdentifier_count > 1) || 
            ( (parameterStructure->MediaLibraryUniqueIdentifier_count != 0) && (parameterStructure->MediaLibraryUniqueIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of MediaLibraryUniqueIdentifier: parameter_count = %d, parameterStructure->MediaLibraryUniqueIdentifier: %p",    \
                              parameterStructure->MediaLibraryUniqueIdentifier_count, parameterStructure->MediaLibraryUniqueIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ItemsPersistentIdentifiers_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2ItemsPersistentIdentifiers[element_loop]), parameterLength, parameterStructure->iAP2ItemsPersistentIdentifiers[element_loop].iAP2BlobLength);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->ItemsStartingIndex_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->ItemsStartingIndex[element_loop]), parameterLength, sizeof(U32) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->MediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->MediaLibraryUniqueIdentifier[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2PlayMediaLibrarySpecialParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2PlayMediaLibrarySpecialParameter* parameterStructure = (iAP2PlayMediaLibrarySpecialParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AllSongs_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AllSongs: parameter_count = %d", parameterStructure->iAP2AllSongs_count);
        }
        if( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count < 1) || (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count > 1) || 
            ( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count != 0) && (parameterStructure->iAP2MediaLibraryUniqueIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaLibraryUniqueIdentifier: parameter_count = %d, parameterStructure->iAP2MediaLibraryUniqueIdentifier: %p",    \
                              parameterStructure->iAP2MediaLibraryUniqueIdentifier_count, parameterStructure->iAP2MediaLibraryUniqueIdentifier);
        }
        if(parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2StartingMediaItemPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AllSongs_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2MediaLibraryUniqueIdentifier[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint64, &(parameterStructure->iAP2StartingMediaItemPersistentIdentifier[element_loop]), parameterLength, sizeof(U64) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartMediaLibraryUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartMediaLibraryUpdatesParameter* parameterStructure = (iAP2StartMediaLibraryUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2LastKnownMediaLibraryRevision_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LastKnownMediaLibraryRevision: parameter_count = %d", parameterStructure->iAP2LastKnownMediaLibraryRevision_count);
        }
        if(parameterStructure->iAP2MediaItemProperties_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemProperties: parameter_count = %d", parameterStructure->iAP2MediaItemProperties_count);
        }
        if(parameterStructure->iAP2MediaLibraryIsHidingRemoteItems_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaLibraryIsHidingRemoteItems: parameter_count = %d", parameterStructure->iAP2MediaLibraryIsHidingRemoteItems_count);
        }
        if( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count < 1) || (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count > 1) || 
            ( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count != 0) && (parameterStructure->iAP2MediaLibraryUniqueIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaLibraryUniqueIdentifier: parameter_count = %d, parameterStructure->iAP2MediaLibraryUniqueIdentifier: %p",    \
                              parameterStructure->iAP2MediaLibraryUniqueIdentifier_count, parameterStructure->iAP2MediaLibraryUniqueIdentifier);
        }
        if(parameterStructure->iAP2MediaLibraryUpdateProgress_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaLibraryUpdateProgress: parameter_count = %d", parameterStructure->iAP2MediaLibraryUpdateProgress_count);
        }
        if(parameterStructure->iAP2MediaPlaylistProperties_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlaylistProperties: parameter_count = %d", parameterStructure->iAP2MediaPlaylistProperties_count);
        }
        if(parameterStructure->iAP2PlayAllSongsCapable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlayAllSongsCapable: parameter_count = %d", parameterStructure->iAP2PlayAllSongsCapable_count);
        }
        if(parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlaylistContentTransferInfoRequest: parameter_count = %d", parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LastKnownMediaLibraryRevision_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2LastKnownMediaLibraryRevision[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemProperties_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2MediaItemProperties Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2MediaItemProperties(&(parameterStructure->iAP2MediaItemProperties[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaLibraryIsHidingRemoteItems_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2MediaLibraryUniqueIdentifier[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaLibraryUpdateProgress_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlaylistProperties_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2MediaPlaylistProperties Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2MediaPlaylistProperties(&(parameterStructure->iAP2MediaPlaylistProperties[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlayAllSongsCapable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2MediaPlaylistContentTransferInfoRequest Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2MediaPlaylistContentTransferInfoRequest(&(parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StopMediaLibraryUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StopMediaLibraryUpdatesParameter* parameterStructure = (iAP2StopMediaLibraryUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count < 1) || 
            ( (parameterStructure->iAP2MediaLibraryUniqueIdentifier_count != 0) && (parameterStructure->iAP2MediaLibraryUniqueIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaLibraryUniqueIdentifier: parameter_count = %d, parameterStructure->iAP2MediaLibraryUniqueIdentifier: %p",    \
                              parameterStructure->iAP2MediaLibraryUniqueIdentifier_count, parameterStructure->iAP2MediaLibraryUniqueIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2MediaLibraryUniqueIdentifier[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2SetNowPlayingInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2SetNowPlayingInformationParameter* parameterStructure = (iAP2SetNowPlayingInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2ElapsedTime_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ElapsedTime: parameter_count = %d", parameterStructure->iAP2ElapsedTime_count);
        }
        if(parameterStructure->iAP2PlaybackQueueIndex_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueIndex: parameter_count = %d", parameterStructure->iAP2PlaybackQueueIndex_count);
        }
        if(parameterStructure->iAP2PlaybackQueueListContentTransferStartIndex_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueListContentTransferStartIndex: parameter_count = %d", parameterStructure->iAP2PlaybackQueueListContentTransferStartIndex_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ElapsedTime_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->iAP2ElapsedTime[element_loop]), parameterLength, sizeof(U32) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueIndex_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->iAP2PlaybackQueueIndex[element_loop]), parameterLength, sizeof(U32) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueListContentTransferStartIndex_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->iAP2PlaybackQueueListContentTransferStartIndex[element_loop]), parameterLength, sizeof(U32) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartNowPlayingUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartNowPlayingUpdatesParameter* parameterStructure = (iAP2StartNowPlayingUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2MediaItemAttributes_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAttributes: parameter_count = %d", parameterStructure->iAP2MediaItemAttributes_count);
        }
        if(parameterStructure->iAP2PlaybackAttributes_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackAttributes: parameter_count = %d", parameterStructure->iAP2PlaybackAttributes_count);
        }
        if(parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueListContentTransferInfoRequest: parameter_count = %d", parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAttributes_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2MediaItemAttributes Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2MediaItemAttributes(&(parameterStructure->iAP2MediaItemAttributes[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackAttributes_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2PlaybackAttributes Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2StartNowPlayingPlaybackAttributes(&(parameterStructure->iAP2PlaybackAttributes[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest_count) && (rc == IAP2_OK) ); element_loop++)
        {
            //Add Parameter Header Length
            rc = iAP2CalculateParSpace(iAP2_group, NULL, parameterLength, 0);
            if(rc == IAP2_OK)
            {
                IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Length of iAP2PlaybackQueueListContentTransferInfoRequest Header is: %d", *parameterLength );
                //Calculate Length of the SubParameter
                rc = iAP2CalcLengthiAP2PlaybackQueueListContentTransferInfoRequest(&(parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest[element_loop]), parameterLength);
                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "rc = %d, element_loop = %d", rc, element_loop);
            }
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2PowerSourceUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2PowerSourceUpdateParameter* parameterStructure = (iAP2PowerSourceUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AvailableCurrentForDevice_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AvailableCurrentForDevice: parameter_count = %d", parameterStructure->iAP2AvailableCurrentForDevice_count);
        }
        if(parameterStructure->iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DeviceBatteryShouldChargeIfPowerIsPresent: parameter_count = %d", parameterStructure->iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AvailableCurrentForDevice_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2AvailableCurrentForDevice[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2DeviceBatteryShouldChargeIfPowerIsPresent[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartPowerUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartPowerUpdatesParameter* parameterStructure = (iAP2StartPowerUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AccessoryPowerMode_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AccessoryPowerMode: parameter_count = %d", parameterStructure->iAP2AccessoryPowerMode_count);
        }
        if(parameterStructure->iAP2BatteryChargeLevel_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BatteryChargeLevel: parameter_count = %d", parameterStructure->iAP2BatteryChargeLevel_count);
        }
        if(parameterStructure->iAP2BatteryChargingState_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BatteryChargingState: parameter_count = %d", parameterStructure->iAP2BatteryChargingState_count);
        }
        if(parameterStructure->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DeviceBatteryWillChargeIfPowerIsPresent: parameter_count = %d", parameterStructure->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count);
        }
        if(parameterStructure->iAP2IsExternalChargerConnected_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2IsExternalChargerConnected: parameter_count = %d", parameterStructure->iAP2IsExternalChargerConnected_count);
        }
        if(parameterStructure->iAP2MaximumcurrentDrawnFromAccessory_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaximumcurrentDrawnFromAccessory: parameter_count = %d", parameterStructure->iAP2MaximumcurrentDrawnFromAccessory_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AccessoryPowerMode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BatteryChargeLevel_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BatteryChargingState_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2IsExternalChargerConnected_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaximumcurrentDrawnFromAccessory_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartTelephonyCallStateInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartTelephonyCallStateInformationParameter* parameterStructure = (iAP2StartTelephonyCallStateInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2CallStatevCardFileTransferIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CallStatevCardFileTransferIdentifier: parameter_count = %d", parameterStructure->iAP2CallStatevCardFileTransferIdentifier_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CallStatevCardFileTransferIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartTelephonyUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartTelephonyUpdatesParameter* parameterStructure = (iAP2StartTelephonyUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2TelephonySignalStrength_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TelephonySignalStrength: parameter_count = %d", parameterStructure->iAP2TelephonySignalStrength_count);
        }
        if(parameterStructure->iAP2TelephonyRegistrationStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TelephonyRegistrationStatus: parameter_count = %d", parameterStructure->iAP2TelephonyRegistrationStatus_count);
        }
        if(parameterStructure->iAP2TelephonyAirplaneModeStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TelephonyAirplaneModeStatus: parameter_count = %d", parameterStructure->iAP2TelephonyAirplaneModeStatus_count);
        }
        if(parameterStructure->iAP2TelephonyTTYStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TelephonyTTYStatus: parameter_count = %d", parameterStructure->iAP2TelephonyTTYStatus_count);
        }
        if(parameterStructure->iAP2TelephonyMobileOperator_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TelephonyMobileOperator: parameter_count = %d", parameterStructure->iAP2TelephonyMobileOperator_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TelephonySignalStrength_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TelephonyRegistrationStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TelephonyAirplaneModeStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TelephonyTTYStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TelephonyMobileOperator_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2VehicleStatusUpdateParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2VehicleStatusUpdateParameter* parameterStructure = (iAP2VehicleStatusUpdateParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2NightMode_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2NightMode: parameter_count = %d", parameterStructure->iAP2NightMode_count);
        }
        if(parameterStructure->iAP2Range_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Range: parameter_count = %d", parameterStructure->iAP2Range_count);
        }
        if(parameterStructure->iAP2OutsideTemperature_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2OutsideTemperature: parameter_count = %d", parameterStructure->iAP2OutsideTemperature_count);
        }
        if(parameterStructure->iAP2InsideTemperature_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2InsideTemperature: parameter_count = %d", parameterStructure->iAP2InsideTemperature_count);
        }
        if(parameterStructure->iAP2RangeWarning_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RangeWarning: parameter_count = %d", parameterStructure->iAP2RangeWarning_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2NightMode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2NightMode[element_loop]), parameterLength, sizeof(U8) );
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2NightMode is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Range_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2Range[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2OutsideTemperature_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_int16, &(parameterStructure->iAP2OutsideTemperature[element_loop]), parameterLength, sizeof(S16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2InsideTemperature_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_int16, &(parameterStructure->iAP2InsideTemperature[element_loop]), parameterLength, sizeof(S16) );
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2InsideTemperature is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RangeWarning_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2RangeWarning[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RequestVoiceOverConfigurationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RequestVoiceOverConfigurationParameter* parameterStructure = (iAP2RequestVoiceOverConfigurationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2VoiceOverSpeakingRate_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverSpeakingRate: parameter_count = %d", parameterStructure->iAP2VoiceOverSpeakingRate_count);
        }
        if(parameterStructure->iAP2VoiceOverSpeakingVolume_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverSpeakingVolume: parameter_count = %d", parameterStructure->iAP2VoiceOverSpeakingVolume_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverSpeakingRate_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2VoiceOverSpeakingRate[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverSpeakingVolume_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2VoiceOverSpeakingVolume[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RequestVoiceOverMoveCursorParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RequestVoiceOverMoveCursorParameter* parameterStructure = (iAP2RequestVoiceOverMoveCursorParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2CursorDirection_count < 1) || (parameterStructure->iAP2CursorDirection_count > 1) || 
            ( (parameterStructure->iAP2CursorDirection_count != 0) && (parameterStructure->iAP2CursorDirection == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2CursorDirection: parameter_count = %d, parameterStructure->iAP2CursorDirection: %p",    \
                              parameterStructure->iAP2CursorDirection_count, parameterStructure->iAP2CursorDirection);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2CursorDirection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2CursorDirection[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RequestVoiceOverScrollPageParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RequestVoiceOverScrollPageParameter* parameterStructure = (iAP2RequestVoiceOverScrollPageParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2ScrollDirection_count < 1) || (parameterStructure->iAP2ScrollDirection_count > 1) || 
            ( (parameterStructure->iAP2ScrollDirection_count != 0) && (parameterStructure->iAP2ScrollDirection == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ScrollDirection: parameter_count = %d, parameterStructure->iAP2ScrollDirection: %p",    \
                              parameterStructure->iAP2ScrollDirection_count, parameterStructure->iAP2ScrollDirection);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ScrollDirection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2ScrollDirection[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RequestVoiceOverSpeakTextParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RequestVoiceOverSpeakTextParameter* parameterStructure = (iAP2RequestVoiceOverSpeakTextParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2VoiceOverTextToSpeak_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverTextToSpeak: parameter_count = %d", parameterStructure->iAP2VoiceOverTextToSpeak_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverTextToSpeak_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2VoiceOverTextToSpeak[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartVoiceOverCursorUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartVoiceOverCursorUpdatesParameter* parameterStructure = (iAP2StartVoiceOverCursorUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2VoiceOverHint_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverHint: parameter_count = %d", parameterStructure->iAP2VoiceOverHint_count);
        }
        if(parameterStructure->iAP2VoiceOverLabel_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverLabel: parameter_count = %d", parameterStructure->iAP2VoiceOverLabel_count);
        }
        if(parameterStructure->iAP2VoiceOverTraits_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverTraits: parameter_count = %d", parameterStructure->iAP2VoiceOverTraits_count);
        }
        if(parameterStructure->iAP2VoiceOverValue_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverValue: parameter_count = %d", parameterStructure->iAP2VoiceOverValue_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverHint_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverLabel_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverTraits_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverValue_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartVoiceOverUpdatesParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartVoiceOverUpdatesParameter* parameterStructure = (iAP2StartVoiceOverUpdatesParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2VoiceOverEnabled_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverEnabled: parameter_count = %d", parameterStructure->iAP2VoiceOverEnabled_count);
        }
        if(parameterStructure->iAP2VoiceOverSpeakingRate_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverSpeakingRate: parameter_count = %d", parameterStructure->iAP2VoiceOverSpeakingRate_count);
        }
        if(parameterStructure->iAP2VoiceOverSpeakingVolume_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2VoiceOverSpeakingVolume: parameter_count = %d", parameterStructure->iAP2VoiceOverSpeakingVolume_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverEnabled_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverSpeakingRate_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2VoiceOverSpeakingVolume_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2AccessoryWiFiConfigurationInformationParameter(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2AccessoryWiFiConfigurationInformationParameter* parameterStructure = (iAP2AccessoryWiFiConfigurationInformationParameter*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2Channel_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Channel: parameter_count = %d", parameterStructure->iAP2Channel_count);
        }
        if(parameterStructure->iAP2Passphrase_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Passphrase: parameter_count = %d", parameterStructure->iAP2Passphrase_count);
        }
        if(parameterStructure->iAP2SecurityType_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2SecurityType: parameter_count = %d", parameterStructure->iAP2SecurityType_count);
        }
        if( (parameterStructure->iAP2WiFiSSID_count < 1) || (parameterStructure->iAP2WiFiSSID_count > 1) || 
            ( (parameterStructure->iAP2WiFiSSID_count != 0) && (parameterStructure->iAP2WiFiSSID == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2WiFiSSID: parameter_count = %d, parameterStructure->iAP2WiFiSSID: %p",    \
                              parameterStructure->iAP2WiFiSSID_count, parameterStructure->iAP2WiFiSSID);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Channel_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2Channel[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Passphrase_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2Passphrase[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2SecurityType_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2SecurityType[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2WiFiSSID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2WiFiSSID[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2BluetoothComponentStatus(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2BluetoothComponentStatus* parameterStructure = (iAP2BluetoothComponentStatus*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2BTComponentEnabled_count < 1) || (parameterStructure->iAP2BTComponentEnabled_count > 1) || 
            ( (parameterStructure->iAP2BTComponentEnabled_count != 0) && (parameterStructure->iAP2BTComponentEnabled == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BTComponentEnabled: parameter_count = %d, parameterStructure->iAP2BTComponentEnabled: %p",    \
                              parameterStructure->iAP2BTComponentEnabled_count, parameterStructure->iAP2BTComponentEnabled);
        }
        if( (parameterStructure->iAP2BTComponentIdentifier_count < 1) || (parameterStructure->iAP2BTComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2BTComponentIdentifier_count != 0) && (parameterStructure->iAP2BTComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BTComponentIdentifier: parameter_count = %d, parameterStructure->iAP2BTComponentIdentifier: %p",    \
                              parameterStructure->iAP2BTComponentIdentifier_count, parameterStructure->iAP2BTComponentIdentifier);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BTComponentEnabled_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_bool, &(parameterStructure->iAP2BTComponentEnabled[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BTComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2BTComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2BluetoothHIDComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2BluetoothHIDComponent* parameterStructure = (iAP2BluetoothHIDComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count < 1) || (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2BluetoothTransportComponentIdentifier_count != 0) && (parameterStructure->iAP2BluetoothTransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BluetoothTransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2BluetoothTransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2BluetoothTransportComponentIdentifier_count, parameterStructure->iAP2BluetoothTransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2HIDComponentFunction_count < 1) || (parameterStructure->iAP2HIDComponentFunction_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentFunction_count != 0) && (parameterStructure->iAP2HIDComponentFunction == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentFunction: parameter_count = %d, parameterStructure->iAP2HIDComponentFunction: %p",    \
                              parameterStructure->iAP2HIDComponentFunction_count, parameterStructure->iAP2HIDComponentFunction);
        }
        if( (parameterStructure->iAP2HIDComponentIdentifier_count < 1) || (parameterStructure->iAP2HIDComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentIdentifier_count != 0) && (parameterStructure->iAP2HIDComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentIdentifier: parameter_count = %d, parameterStructure->iAP2HIDComponentIdentifier: %p",    \
                              parameterStructure->iAP2HIDComponentIdentifier_count, parameterStructure->iAP2HIDComponentIdentifier);
        }
        if( (parameterStructure->iAP2HIDComponentName_count < 1) || (parameterStructure->iAP2HIDComponentName_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentName_count != 0) && (parameterStructure->iAP2HIDComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentName: parameter_count = %d, parameterStructure->iAP2HIDComponentName: %p",    \
                              parameterStructure->iAP2HIDComponentName_count, parameterStructure->iAP2HIDComponentName);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothTransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2BluetoothTransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentFunction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2HIDComponentFunction[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2HIDComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2HIDComponentName[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2BluetoothTransportComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2BluetoothTransportComponent* parameterStructure = (iAP2BluetoothTransportComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress_count < 1) || (parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress_count > 1) || 
            ( (parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress_count != 0) && (parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2BluetoothTransportMediaAccessControlAddress: parameter_count = %d, parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress: %p",    \
                              parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress_count, parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress);
        }
        if( (parameterStructure->iAP2TransportComponentIdentifier_count < 1) || (parameterStructure->iAP2TransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentIdentifier_count != 0) && (parameterStructure->iAP2TransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2TransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2TransportComponentIdentifier_count, parameterStructure->iAP2TransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2TransportComponentName_count < 1) || (parameterStructure->iAP2TransportComponentName_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentName_count != 0) && (parameterStructure->iAP2TransportComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentName: parameter_count = %d, parameterStructure->iAP2TransportComponentName: %p",    \
                              parameterStructure->iAP2TransportComponentName_count, parameterStructure->iAP2TransportComponentName);
        }
        if(parameterStructure->iAP2TransportSupportsiAP2Connection_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsiAP2Connection: parameter_count = %d", parameterStructure->iAP2TransportSupportsiAP2Connection_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_blob, &(parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress[element_loop]), parameterLength, parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress[element_loop].iAP2BlobLength);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2TransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2TransportComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsiAP2Connection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2ExternalAccessoryProtocol(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2ExternalAccessoryProtocol* parameterStructure = (iAP2ExternalAccessoryProtocol*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2ExternalAccessoryProtocolCarPlay_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ExternalAccessoryProtocolCarPlay: parameter_count = %d", parameterStructure->iAP2ExternalAccessoryProtocolCarPlay_count);
        }
        if( (parameterStructure->iAP2ExternalAccessoryProtocolIdentifier_count < 1) || (parameterStructure->iAP2ExternalAccessoryProtocolIdentifier_count > 1) || 
            ( (parameterStructure->iAP2ExternalAccessoryProtocolIdentifier_count != 0) && (parameterStructure->iAP2ExternalAccessoryProtocolIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ExternalAccessoryProtocolIdentifier: parameter_count = %d, parameterStructure->iAP2ExternalAccessoryProtocolIdentifier: %p",    \
                              parameterStructure->iAP2ExternalAccessoryProtocolIdentifier_count, parameterStructure->iAP2ExternalAccessoryProtocolIdentifier);
        }
        if( (parameterStructure->iAP2ExternalAccessoryProtocolMatchAction_count < 1) || (parameterStructure->iAP2ExternalAccessoryProtocolMatchAction_count > 1) || 
            ( (parameterStructure->iAP2ExternalAccessoryProtocolMatchAction_count != 0) && (parameterStructure->iAP2ExternalAccessoryProtocolMatchAction == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ExternalAccessoryProtocolMatchAction: parameter_count = %d, parameterStructure->iAP2ExternalAccessoryProtocolMatchAction: %p",    \
                              parameterStructure->iAP2ExternalAccessoryProtocolMatchAction_count, parameterStructure->iAP2ExternalAccessoryProtocolMatchAction);
        }
        if( (parameterStructure->iAP2ExternalAccessoryProtocolName_count < 1) || (parameterStructure->iAP2ExternalAccessoryProtocolName_count > 1) || 
            ( (parameterStructure->iAP2ExternalAccessoryProtocolName_count != 0) && (parameterStructure->iAP2ExternalAccessoryProtocolName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2ExternalAccessoryProtocolName: parameter_count = %d, parameterStructure->iAP2ExternalAccessoryProtocolName: %p",    \
                              parameterStructure->iAP2ExternalAccessoryProtocolName_count, parameterStructure->iAP2ExternalAccessoryProtocolName);
        }
        if(parameterStructure->iAP2NativeTransportComponentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2NativeTransportComponentIdentifier: parameter_count = %d", parameterStructure->iAP2NativeTransportComponentIdentifier_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocolCarPlay_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocolIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2ExternalAccessoryProtocolIdentifier[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocolMatchAction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2ExternalAccessoryProtocolMatchAction[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2ExternalAccessoryProtocolName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2ExternalAccessoryProtocolName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2NativeTransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2NativeTransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2FavoritesListProperties(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2FavoritesListProperties* parameterStructure = (iAP2FavoritesListProperties*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AddressBookID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AddressBookID: parameter_count = %d", parameterStructure->iAP2AddressBookID_count);
        }
        if((parameterStructure->iAP2DisplayName_count < 1) || (parameterStructure->iAP2DisplayName_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DisplayName: parameter_count = %d, parameterStructure->iAP2DisplayName: %p",    \
                              parameterStructure->iAP2DisplayName_count, parameterStructure->iAP2DisplayName);
        }
        if((parameterStructure->iAP2Index_count < 1) || (parameterStructure->iAP2Index_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Index: parameter_count = %d, parameterStructure->iAP2Index: %p",    \
                              parameterStructure->iAP2Index_count, parameterStructure->iAP2Index);
        }
        if(parameterStructure->iAP2Label_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Label: parameter_count = %d", parameterStructure->iAP2Label_count);
        }
        if((parameterStructure->iAP2RemoteID_count < 1) || (parameterStructure->iAP2RemoteID_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RemoteID: parameter_count = %d, parameterStructure->iAP2RemoteID: %p",    \
                              parameterStructure->iAP2RemoteID_count, parameterStructure->iAP2RemoteID);
        }
        if((parameterStructure->iAP2Service_count < 1) || (parameterStructure->iAP2Service_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Service: parameter_count = %d, parameterStructure->iAP2Service: %p",    \
                              parameterStructure->iAP2Service_count, parameterStructure->iAP2Service);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AddressBookID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DisplayName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Index_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Label_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RemoteID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Service_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2iAP2HIDComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2iAP2HIDComponent* parameterStructure = (iAP2iAP2HIDComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2HIDComponentFunction_count < 1) || (parameterStructure->iAP2HIDComponentFunction_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentFunction_count != 0) && (parameterStructure->iAP2HIDComponentFunction == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentFunction: parameter_count = %d, parameterStructure->iAP2HIDComponentFunction: %p",    \
                              parameterStructure->iAP2HIDComponentFunction_count, parameterStructure->iAP2HIDComponentFunction);
        }
        if( (parameterStructure->iAP2HIDComponentIdentifier_count < 1) || (parameterStructure->iAP2HIDComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentIdentifier_count != 0) && (parameterStructure->iAP2HIDComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentIdentifier: parameter_count = %d, parameterStructure->iAP2HIDComponentIdentifier: %p",    \
                              parameterStructure->iAP2HIDComponentIdentifier_count, parameterStructure->iAP2HIDComponentIdentifier);
        }
        if( (parameterStructure->iAP2HIDComponentName_count < 1) || (parameterStructure->iAP2HIDComponentName_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentName_count != 0) && (parameterStructure->iAP2HIDComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentName: parameter_count = %d, parameterStructure->iAP2HIDComponentName: %p",    \
                              parameterStructure->iAP2HIDComponentName_count, parameterStructure->iAP2HIDComponentName);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentFunction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2HIDComponentFunction[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2HIDComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2HIDComponentName[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2LocationInformationComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2LocationInformationComponent* parameterStructure = (iAP2LocationInformationComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2LocationInformationComponentGlobalPositioningSystemFixData_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentGlobalPositioningSystemFixData: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentGlobalPositioningSystemFixData_count);
        }
        if(parameterStructure->iAP2LocationInformationComponentGPSSatelliteInView_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentGPSSatelliteInView: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentGPSSatelliteInView_count);
        }
        if( (parameterStructure->iAP2LocationInformationComponentIdentifier_count < 1) || (parameterStructure->iAP2LocationInformationComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2LocationInformationComponentIdentifier_count != 0) && (parameterStructure->iAP2LocationInformationComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentIdentifier: parameter_count = %d, parameterStructure->iAP2LocationInformationComponentIdentifier: %p",    \
                              parameterStructure->iAP2LocationInformationComponentIdentifier_count, parameterStructure->iAP2LocationInformationComponentIdentifier);
        }
        if( (parameterStructure->iAP2LocationInformationComponentName_count < 1) || (parameterStructure->iAP2LocationInformationComponentName_count > 1) || 
            ( (parameterStructure->iAP2LocationInformationComponentName_count != 0) && (parameterStructure->iAP2LocationInformationComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentName: parameter_count = %d, parameterStructure->iAP2LocationInformationComponentName: %p",    \
                              parameterStructure->iAP2LocationInformationComponentName_count, parameterStructure->iAP2LocationInformationComponentName);
        }
        if(parameterStructure->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData_count);
        }
        if(parameterStructure->iAP2LocationInformationComponentVehicleAccelerometerData_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentVehicleAccelerometerData: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentVehicleAccelerometerData_count);
        }
        if(parameterStructure->iAP2LocationInformationComponentVehicleGyroData_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentVehicleGyroData: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentVehicleGyroData_count);
        }
        if(parameterStructure->iAP2LocationInformationComponentVehicleHeadingData_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentVehicleHeadingData: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentVehicleHeadingData_count);
        }
        if(parameterStructure->iAP2LocationInformationComponentVehicleSpeedData_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2LocationInformationComponentVehicleSpeedData: parameter_count = %d", parameterStructure->iAP2LocationInformationComponentVehicleSpeedData_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentGlobalPositioningSystemFixData_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentGPSSatelliteInView_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2LocationInformationComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2LocationInformationComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentVehicleAccelerometerData_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentVehicleGyroData_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentVehicleHeadingData_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2LocationInformationComponentVehicleSpeedData_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2MediaItemAttributes(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2MediaItemAttributes* parameterStructure = (iAP2MediaItemAttributes*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2MediaItemAlbumDiscCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumDiscCount: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumDiscCount_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumDiscNumber_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumDiscNumber: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumDiscNumber_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumTitle: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumTitle_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumTrackCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumTrackCount: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumTrackCount_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumTrackNumber_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumTrackNumber: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumTrackNumber_count);
        }
        if(parameterStructure->iAP2MediaItemArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemArtist: parameter_count = %d", parameterStructure->iAP2MediaItemArtist_count);
        }
        if(parameterStructure->iAP2MediaItemArtworkFileTransferIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemArtworkFileTransferIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemArtworkFileTransferIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemChapterCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemChapterCount: parameter_count = %d", parameterStructure->iAP2MediaItemChapterCount_count);
        }
        if(parameterStructure->iAP2MediaItemComposer_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemComposer: parameter_count = %d", parameterStructure->iAP2MediaItemComposer_count);
        }
        if(parameterStructure->iAP2MediaItemGenre_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemGenre: parameter_count = %d", parameterStructure->iAP2MediaItemGenre_count);
        }
        if(parameterStructure->iAP2MediaItemIsBanned_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemIsBanned: parameter_count = %d", parameterStructure->iAP2MediaItemIsBanned_count);
        }
        if(parameterStructure->iAP2MediaItemIsBanSupported_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemIsBanSupported: parameter_count = %d", parameterStructure->iAP2MediaItemIsBanSupported_count);
        }
        if(parameterStructure->iAP2MediaItemIsLiked_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemIsLiked: parameter_count = %d", parameterStructure->iAP2MediaItemIsLiked_count);
        }
        if(parameterStructure->iAP2MediaItemIsLikeSupported_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemIsLikeSupported: parameter_count = %d", parameterStructure->iAP2MediaItemIsLikeSupported_count);
        }
        if(parameterStructure->iAP2MediaItemPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemPersistentIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemPlaybackDurationInMilliseconds_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPlaybackDurationInMilliseconds: parameter_count = %d", parameterStructure->iAP2MediaItemPlaybackDurationInMilliseconds_count);
        }
        if(parameterStructure->iAP2MediaItemTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemTitle: parameter_count = %d", parameterStructure->iAP2MediaItemTitle_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumDiscCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumDiscNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumTrackCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumTrackNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemArtworkFileTransferIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemChapterCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemComposer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemGenre_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemIsBanned_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemIsBanSupported_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemIsLiked_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemIsLikeSupported_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPlaybackDurationInMilliseconds_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2MediaItemProperties(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2MediaItemProperties* parameterStructure = (iAP2MediaItemProperties*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2MediaItemPropertyAlbumArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumArtist: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumArtist_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumArtistPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumDiscCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumDiscCount: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumDiscCount_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumDiscNumber_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumDiscNumber: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumDiscNumber_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumPersistentIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumTitle: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumTitle_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumTrackCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumTrackCount: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumTrackCount_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyAlbumTrackNumber_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyAlbumTrackNumber: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyAlbumTrackNumber_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyArtist: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyArtist_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyArtistPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyArtistPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyArtistPersistentIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyChapterCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyChapterCount: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyChapterCount_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyComposer_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyComposer: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyComposer_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyComposerPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyComposerPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyComposerPersistentIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyGenre_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyGenre: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyGenre_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyGenrePersistenIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyGenrePersistenIdentifier: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyGenrePersistenIdentifier_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyIsBanned_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyIsBanned: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyIsBanned_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyIsBanSupported_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyIsBanSupported: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyIsBanSupported_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyIsLiked_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyIsLiked: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyIsLiked_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyIsLikeSupported_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyIsLikeSupported: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyIsLikeSupported_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyIsPartOfCompilation_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyIsPartOfCompilation: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyIsPartOfCompilation_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyIsResidentOndevice_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyIsResidentOndevice: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyIsResidentOndevice_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyMediaType_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyMediaType: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyMediaType_count);
        }
        if((parameterStructure->iAP2MediaItemPropertyPersistentIdentifier_count < 1) || (parameterStructure->iAP2MediaItemPropertyPersistentIdentifier_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyPersistentIdentifier: parameter_count = %d, parameterStructure->iAP2MediaItemPropertyPersistentIdentifier: %p",    \
                              parameterStructure->iAP2MediaItemPropertyPersistentIdentifier_count, parameterStructure->iAP2MediaItemPropertyPersistentIdentifier);
        }
        if(parameterStructure->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyPlaybackDurationInMilliseconds: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyRating_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyRating: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyRating_count);
        }
        if(parameterStructure->iAP2MediaItemPropertyTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPropertyTitle: parameter_count = %d", parameterStructure->iAP2MediaItemPropertyTitle_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumDiscCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumDiscNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumTrackCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyAlbumTrackNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyArtistPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyChapterCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyComposer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyComposerPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyGenre_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyGenrePersistenIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyIsBanned_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsBanned is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyIsBanSupported_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsBanSupported is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyIsLiked_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsLiked is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyIsLikeSupported_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsLikeSupported is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyIsPartOfCompilation_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyIsResidentOndevice_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyMediaType_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyRating_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPropertyTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2MediaPlaylistContentTransferInfoRequest(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2MediaPlaylistContentTransferInfoRequest* parameterStructure = (iAP2MediaPlaylistContentTransferInfoRequest*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2MedialtemPlD_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MedialtemPlD: parameter_count = %d", parameterStructure->iAP2MedialtemPlD_count);
        }
        if(parameterStructure->iAP2MedialtemTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MedialtemTitle: parameter_count = %d", parameterStructure->iAP2MedialtemTitle_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumTitle: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumTitle_count);
        }
        if(parameterStructure->iAP2MediaItemArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemArtist: parameter_count = %d", parameterStructure->iAP2MediaItemArtist_count);
        }
        if(parameterStructure->iAP2MedialtemAlbumArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MedialtemAlbumArtist: parameter_count = %d", parameterStructure->iAP2MedialtemAlbumArtist_count);
        }
        if(parameterStructure->iAP2MediaItemGenre_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemGenre: parameter_count = %d", parameterStructure->iAP2MediaItemGenre_count);
        }
        if(parameterStructure->iAP2MediaItemComposer_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemComposer: parameter_count = %d", parameterStructure->iAP2MediaItemComposer_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MedialtemPlD_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MedialtemTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MedialtemAlbumArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemGenre_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemComposer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2MediaPlaylistProperties(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2MediaPlaylistProperties* parameterStructure = (iAP2MediaPlaylistProperties*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2MediaPlayListContainedMediaItems_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListContainedMediaItems: parameter_count = %d", parameterStructure->iAP2MediaPlayListContainedMediaItems_count);
        }
        if(parameterStructure->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier: parameter_count = %d", parameterStructure->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count);
        }
        if(parameterStructure->iAP2MediaPlayListPropertyIsAppleMusicRadioStation_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyIsAppleMusicRadioStation: parameter_count = %d", parameterStructure->iAP2MediaPlayListPropertyIsAppleMusicRadioStation_count);
        }
        if(parameterStructure->iAP2MediaPlayListPropertyIsFolder_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyIsFolder: parameter_count = %d", parameterStructure->iAP2MediaPlayListPropertyIsFolder_count);
        }
        if(parameterStructure->iAP2MediaPlayListPropertyIsiTunesRadioStation_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyIsiTunesRadioStation: parameter_count = %d", parameterStructure->iAP2MediaPlayListPropertyIsiTunesRadioStation_count);
        }
        if(parameterStructure->iAP2MediaPlayListPropertyName_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyName: parameter_count = %d", parameterStructure->iAP2MediaPlayListPropertyName_count);
        }
        if(parameterStructure->iAP2MediaPlayListPropertyParentPersistentIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyParentPersistentIdentifier: parameter_count = %d", parameterStructure->iAP2MediaPlayListPropertyParentPersistentIdentifier_count);
        }
        if((parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier_count < 1) || (parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyPersistentIdentifier: parameter_count = %d, parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier: %p",    \
                              parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier_count, parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier);
        }
        if(parameterStructure->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlayListPropertyPropertyIsGeniusMix: parameter_count = %d", parameterStructure->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count);
        }
        if(parameterStructure->iAP2MediaPlaylistContentTransfer_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaPlaylistContentTransfer: parameter_count = %d", parameterStructure->iAP2MediaPlaylistContentTransfer_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListContainedMediaItems_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaPlayListContainedMediaItems is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyIsAppleMusicRadioStation_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyIsFolder_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyIsiTunesRadioStation_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaPlayListPropertyIsiTunesRadioStation is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyParentPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaPlaylistContentTransfer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2PlaybackQueueListContentTransferInfoRequest(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2PlaybackQueueListContentTransferInfoRequest* parameterStructure = (iAP2PlaybackQueueListContentTransferInfoRequest*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2MediaItemPID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemPID: parameter_count = %d", parameterStructure->iAP2MediaItemPID_count);
        }
        if(parameterStructure->iAP2MediaItemTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemTitle: parameter_count = %d", parameterStructure->iAP2MediaItemTitle_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumTitle_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumTitle: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumTitle_count);
        }
        if(parameterStructure->iAP2MediaItemArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemArtist: parameter_count = %d", parameterStructure->iAP2MediaItemArtist_count);
        }
        if(parameterStructure->iAP2MediaItemAlbumArtist_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemAlbumArtist: parameter_count = %d", parameterStructure->iAP2MediaItemAlbumArtist_count);
        }
        if(parameterStructure->iAP2MediaItemGenre_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemGenre: parameter_count = %d", parameterStructure->iAP2MediaItemGenre_count);
        }
        if(parameterStructure->iAP2MediaItemComposer_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MediaItemComposer: parameter_count = %d", parameterStructure->iAP2MediaItemComposer_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemPID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumTitle_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemAlbumArtist_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemGenre_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MediaItemComposer_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RecentsListProperties(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RecentsListProperties* parameterStructure = (iAP2RecentsListProperties*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2AddressBookID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2AddressBookID: parameter_count = %d", parameterStructure->iAP2AddressBookID_count);
        }
        if((parameterStructure->iAP2DisplayName_count < 1) || (parameterStructure->iAP2DisplayName_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DisplayName: parameter_count = %d, parameterStructure->iAP2DisplayName: %p",    \
                              parameterStructure->iAP2DisplayName_count, parameterStructure->iAP2DisplayName);
        }
        if(parameterStructure->iAP2Duration_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Duration: parameter_count = %d", parameterStructure->iAP2Duration_count);
        }
        if((parameterStructure->iAP2Index_count < 1) || (parameterStructure->iAP2Index_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Index: parameter_count = %d, parameterStructure->iAP2Index: %p",    \
                              parameterStructure->iAP2Index_count, parameterStructure->iAP2Index);
        }
        if(parameterStructure->iAP2Label_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Label: parameter_count = %d", parameterStructure->iAP2Label_count);
        }
        if((parameterStructure->iAP2Occurrences_count < 1) || (parameterStructure->iAP2Occurrences_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Occurrences: parameter_count = %d, parameterStructure->iAP2Occurrences: %p",    \
                              parameterStructure->iAP2Occurrences_count, parameterStructure->iAP2Occurrences);
        }
        if((parameterStructure->iAP2RemoteID_count < 1) || (parameterStructure->iAP2RemoteID_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RemoteID: parameter_count = %d, parameterStructure->iAP2RemoteID: %p",    \
                              parameterStructure->iAP2RemoteID_count, parameterStructure->iAP2RemoteID);
        }
        if((parameterStructure->iAP2Service_count < 1) || (parameterStructure->iAP2Service_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Service: parameter_count = %d, parameterStructure->iAP2Service: %p",    \
                              parameterStructure->iAP2Service_count, parameterStructure->iAP2Service);
        }
        if((parameterStructure->iAP2Type_count < 1) || (parameterStructure->iAP2Type_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Type: parameter_count = %d, parameterStructure->iAP2Type: %p",    \
                              parameterStructure->iAP2Type_count, parameterStructure->iAP2Type);
        }
        if(parameterStructure->iAP2UnixTimestamp_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2UnixTimestamp: parameter_count = %d", parameterStructure->iAP2UnixTimestamp_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2AddressBookID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DisplayName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Duration_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Index_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Label_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Occurrences_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RemoteID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Service_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Type_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2UnixTimestamp_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2RouteGuidanceDisplayComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2RouteGuidanceDisplayComponent* parameterStructure = (iAP2RouteGuidanceDisplayComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2Identifier_count < 1) || (parameterStructure->iAP2Identifier_count > 1) || 
            ( (parameterStructure->iAP2Identifier_count != 0) && (parameterStructure->iAP2Identifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Identifier: parameter_count = %d, parameterStructure->iAP2Identifier: %p",    \
                              parameterStructure->iAP2Identifier_count, parameterStructure->iAP2Identifier);
        }
        if( (parameterStructure->iAP2Name_count < 1) || (parameterStructure->iAP2Name_count > 1) || 
            ( (parameterStructure->iAP2Name_count != 0) && (parameterStructure->iAP2Name == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Name: parameter_count = %d, parameterStructure->iAP2Name: %p",    \
                              parameterStructure->iAP2Name_count, parameterStructure->iAP2Name);
        }
        if(parameterStructure->iAP2MaxCurrentRoadNameLength_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaxCurrentRoadNameLength: parameter_count = %d", parameterStructure->iAP2MaxCurrentRoadNameLength_count);
        }
        if(parameterStructure->iAP2MaxDestinationRoadNameLength_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaxDestinationRoadNameLength: parameter_count = %d", parameterStructure->iAP2MaxDestinationRoadNameLength_count);
        }
        if(parameterStructure->iAP2MaxAfterManeuverRoadNameLength_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaxAfterManeuverRoadNameLength: parameter_count = %d", parameterStructure->iAP2MaxAfterManeuverRoadNameLength_count);
        }
        if(parameterStructure->iAP2MaxManeuverDescriptionLength_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaxManeuverDescriptionLength: parameter_count = %d", parameterStructure->iAP2MaxManeuverDescriptionLength_count);
        }
        if(parameterStructure->iAP2MaxGuidanceManeuverStorageCapacity_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2MaxGuidanceManeuverStorageCapacity: parameter_count = %d", parameterStructure->iAP2MaxGuidanceManeuverStorageCapacity_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Identifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2Identifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Name_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2Name[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaxCurrentRoadNameLength_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2MaxCurrentRoadNameLength[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaxDestinationRoadNameLength_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2MaxDestinationRoadNameLength[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaxAfterManeuverRoadNameLength_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2MaxAfterManeuverRoadNameLength[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaxManeuverDescriptionLength_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2MaxManeuverDescriptionLength[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2MaxGuidanceManeuverStorageCapacity_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2MaxGuidanceManeuverStorageCapacity[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2SerialTransportComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2SerialTransportComponent* parameterStructure = (iAP2SerialTransportComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2TransportComponentIdentifier_count < 1) || (parameterStructure->iAP2TransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentIdentifier_count != 0) && (parameterStructure->iAP2TransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2TransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2TransportComponentIdentifier_count, parameterStructure->iAP2TransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2TransportComponentName_count < 1) || (parameterStructure->iAP2TransportComponentName_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentName_count != 0) && (parameterStructure->iAP2TransportComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentName: parameter_count = %d, parameterStructure->iAP2TransportComponentName: %p",    \
                              parameterStructure->iAP2TransportComponentName_count, parameterStructure->iAP2TransportComponentName);
        }
        if(parameterStructure->iAP2TransportSupportsiAP2Connection_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsiAP2Connection: parameter_count = %d", parameterStructure->iAP2TransportSupportsiAP2Connection_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2TransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2TransportComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsiAP2Connection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2StartNowPlayingPlaybackAttributes(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2StartNowPlayingPlaybackAttributes* parameterStructure = (iAP2StartNowPlayingPlaybackAttributes*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if(parameterStructure->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID: parameter_count = %d", parameterStructure->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count);
        }
        if(parameterStructure->iAP2PBAppleMusicRadioAd_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PBAppleMusicRadioAd: parameter_count = %d", parameterStructure->iAP2PBAppleMusicRadioAd_count);
        }
        if(parameterStructure->iAP2PBAppleMusicRadioStationName_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PBAppleMusicRadioStationName: parameter_count = %d", parameterStructure->iAP2PBAppleMusicRadioStationName_count);
        }
        if(parameterStructure->iAP2PBiTunesRadioAd_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PBiTunesRadioAd: parameter_count = %d", parameterStructure->iAP2PBiTunesRadioAd_count);
        }
        if(parameterStructure->iAP2PBiTunesStationMediaPlaylistPersistentID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PBiTunesStationMediaPlaylistPersistentID: parameter_count = %d", parameterStructure->iAP2PBiTunesStationMediaPlaylistPersistentID_count);
        }
        if(parameterStructure->iAP2PBiTunesStationName_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PBiTunesStationName: parameter_count = %d", parameterStructure->iAP2PBiTunesStationName_count);
        }
        if((parameterStructure->iAP2PlaybackAppBundleID_count < 1) || (parameterStructure->iAP2PlaybackAppBundleID_count > 1))
        {
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "According to latest specification iAP2PlaybackAppBundleID is mandatory. But an invalid value is provided ");
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackAppBundleID: parameter_count = %d, parameterStructure->iAP2PlaybackAppBundleID: %p",    \
                              parameterStructure->iAP2PlaybackAppBundleID_count, parameterStructure->iAP2PlaybackAppBundleID);
        }
        if((parameterStructure->iAP2PlaybackAppName_count < 1) || (parameterStructure->iAP2PlaybackAppName_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackAppName: parameter_count = %d, parameterStructure->iAP2PlaybackAppName: %p",    \
                              parameterStructure->iAP2PlaybackAppName_count, parameterStructure->iAP2PlaybackAppName);
        }
        if(parameterStructure->iAP2PlaybackElapsedTimeInMilliseconds_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackElapsedTimeInMilliseconds: parameter_count = %d", parameterStructure->iAP2PlaybackElapsedTimeInMilliseconds_count);
        }
        if(parameterStructure->iAP2PlaybackMediaLibraryUniqueIdentifier_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackMediaLibraryUniqueIdentifier: parameter_count = %d", parameterStructure->iAP2PlaybackMediaLibraryUniqueIdentifier_count);
        }
        if(parameterStructure->iAP2PlaybackQueueChapterIndex_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueChapterIndex: parameter_count = %d", parameterStructure->iAP2PlaybackQueueChapterIndex_count);
        }
        if(parameterStructure->iAP2PlaybackQueueCount_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueCount: parameter_count = %d", parameterStructure->iAP2PlaybackQueueCount_count);
        }
        if(parameterStructure->iAP2PlaybackQueueIndex_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueIndex: parameter_count = %d", parameterStructure->iAP2PlaybackQueueIndex_count);
        }
        if(parameterStructure->iAP2PlaybackQueueListAvail_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueListAvail: parameter_count = %d", parameterStructure->iAP2PlaybackQueueListAvail_count);
        }
        if(parameterStructure->iAP2PlaybackQueueListTransferID_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueListTransferID: parameter_count = %d", parameterStructure->iAP2PlaybackQueueListTransferID_count);
        }
        if(parameterStructure->iAP2PlaybackRepeatMode_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackRepeatMode: parameter_count = %d", parameterStructure->iAP2PlaybackRepeatMode_count);
        }
        if(parameterStructure->iAP2PlaybackShuffleMode_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackShuffleMode: parameter_count = %d", parameterStructure->iAP2PlaybackShuffleMode_count);
        }
        if(parameterStructure->iAP2PlaybackSpeed_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackSpeed: parameter_count = %d", parameterStructure->iAP2PlaybackSpeed_count);
        }
        if(parameterStructure->iAP2PlaybackStatus_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackStatus: parameter_count = %d", parameterStructure->iAP2PlaybackStatus_count);
        }
        if(parameterStructure->iAP2SetElapsedTimeAvailable_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2SetElapsedTimeAvailable: parameter_count = %d", parameterStructure->iAP2SetElapsedTimeAvailable_count);
        }
        if(parameterStructure->iAP2PlaybackQueueListContentTransferSize_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2PlaybackQueueListContentTransferSize: parameter_count = %d", parameterStructure->iAP2PlaybackQueueListContentTransferSize_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PBAppleMusicRadioAd_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PBAppleMusicRadioStationName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PBiTunesRadioAd_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesRadioAd is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PBiTunesStationMediaPlaylistPersistentID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesStationMediaPlaylistPersistentID is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PBiTunesStationName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesStationName is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackAppBundleID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackAppName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackElapsedTimeInMilliseconds_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackMediaLibraryUniqueIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueChapterIndex_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueCount_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueIndex_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueListAvail_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueListTransferID_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackRepeatMode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackShuffleMode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackSpeed_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackStatus_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2SetElapsedTimeAvailable_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2PlaybackQueueListContentTransferSize_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint32, &(parameterStructure->iAP2PlaybackQueueListContentTransferSize[element_loop]), parameterLength, sizeof(U32) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2USBDeviceTransportComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2USBDeviceTransportComponent* parameterStructure = (iAP2USBDeviceTransportComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2TransportComponentIdentifier_count < 1) || (parameterStructure->iAP2TransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentIdentifier_count != 0) && (parameterStructure->iAP2TransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2TransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2TransportComponentIdentifier_count, parameterStructure->iAP2TransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2TransportComponentName_count < 1) || (parameterStructure->iAP2TransportComponentName_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentName_count != 0) && (parameterStructure->iAP2TransportComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentName: parameter_count = %d, parameterStructure->iAP2TransportComponentName: %p",    \
                              parameterStructure->iAP2TransportComponentName_count, parameterStructure->iAP2TransportComponentName);
        }
        if(parameterStructure->iAP2TransportSupportsiAP2Connection_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsiAP2Connection: parameter_count = %d", parameterStructure->iAP2TransportSupportsiAP2Connection_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2TransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2TransportComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsiAP2Connection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBDeviceSupportedAudioSampleRate_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2USBDeviceSupportedAudioSampleRate[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2USBHostHIDComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2USBHostHIDComponent* parameterStructure = (iAP2USBHostHIDComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2HIDComponentFunction_count < 1) || (parameterStructure->iAP2HIDComponentFunction_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentFunction_count != 0) && (parameterStructure->iAP2HIDComponentFunction == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentFunction: parameter_count = %d, parameterStructure->iAP2HIDComponentFunction: %p",    \
                              parameterStructure->iAP2HIDComponentFunction_count, parameterStructure->iAP2HIDComponentFunction);
        }
        if( (parameterStructure->iAP2HIDComponentIdentifier_count < 1) || (parameterStructure->iAP2HIDComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentIdentifier_count != 0) && (parameterStructure->iAP2HIDComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentIdentifier: parameter_count = %d, parameterStructure->iAP2HIDComponentIdentifier: %p",    \
                              parameterStructure->iAP2HIDComponentIdentifier_count, parameterStructure->iAP2HIDComponentIdentifier);
        }
        if( (parameterStructure->iAP2HIDComponentName_count < 1) || (parameterStructure->iAP2HIDComponentName_count > 1) || 
            ( (parameterStructure->iAP2HIDComponentName_count != 0) && (parameterStructure->iAP2HIDComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2HIDComponentName: parameter_count = %d, parameterStructure->iAP2HIDComponentName: %p",    \
                              parameterStructure->iAP2HIDComponentName_count, parameterStructure->iAP2HIDComponentName);
        }
        if( (parameterStructure->iAP2USBHostTransportComponentIdentifier_count < 1) || (parameterStructure->iAP2USBHostTransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2USBHostTransportComponentIdentifier_count != 0) && (parameterStructure->iAP2USBHostTransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2USBHostTransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2USBHostTransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2USBHostTransportComponentIdentifier_count, parameterStructure->iAP2USBHostTransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2USBHostTransportInterfaceNumber_count < 1) || (parameterStructure->iAP2USBHostTransportInterfaceNumber_count > 1) || 
            ( (parameterStructure->iAP2USBHostTransportInterfaceNumber_count != 0) && (parameterStructure->iAP2USBHostTransportInterfaceNumber == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2USBHostTransportInterfaceNumber: parameter_count = %d, parameterStructure->iAP2USBHostTransportInterfaceNumber: %p",    \
                              parameterStructure->iAP2USBHostTransportInterfaceNumber_count, parameterStructure->iAP2USBHostTransportInterfaceNumber);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentFunction_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2HIDComponentFunction[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2HIDComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2HIDComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2HIDComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBHostTransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2USBHostTransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBHostTransportInterfaceNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2USBHostTransportInterfaceNumber[element_loop]), parameterLength, sizeof(U16) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2USBHostTransportComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2USBHostTransportComponent* parameterStructure = (iAP2USBHostTransportComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2TransportComponentIdentifier_count < 1) || (parameterStructure->iAP2TransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentIdentifier_count != 0) && (parameterStructure->iAP2TransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2TransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2TransportComponentIdentifier_count, parameterStructure->iAP2TransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2TransportComponentName_count < 1) || (parameterStructure->iAP2TransportComponentName_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentName_count != 0) && (parameterStructure->iAP2TransportComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentName: parameter_count = %d, parameterStructure->iAP2TransportComponentName: %p",    \
                              parameterStructure->iAP2TransportComponentName_count, parameterStructure->iAP2TransportComponentName);
        }
        if(parameterStructure->iAP2TransportSupportsCarPlay_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsCarPlay: parameter_count = %d", parameterStructure->iAP2TransportSupportsCarPlay_count);
        }
        if(parameterStructure->iAP2TransportSupportsiAP2Connection_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsiAP2Connection: parameter_count = %d", parameterStructure->iAP2TransportSupportsiAP2Connection_count);
        }
        if(parameterStructure->iAP2USBHostTransportCarPlaytInterfaceNumber_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2USBHostTransportCarPlaytInterfaceNumber: parameter_count = %d", parameterStructure->iAP2USBHostTransportCarPlaytInterfaceNumber_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2TransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2TransportComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsCarPlay_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsiAP2Connection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2USBHostTransportCarPlaytInterfaceNumber_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint8, &(parameterStructure->iAP2USBHostTransportCarPlaytInterfaceNumber[element_loop]), parameterLength, sizeof(U8) );
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2VehicleInformationComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2VehicleInformationComponent* parameterStructure = (iAP2VehicleInformationComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2DisplayName_count < 1) || (parameterStructure->iAP2DisplayName_count > 1) || 
            ( (parameterStructure->iAP2DisplayName_count != 0) && (parameterStructure->iAP2DisplayName == NULL) ) )
        {
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "According to latest specification iAP2DisplayName is mandatory. But an invalid value is provided ");
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2DisplayName: parameter_count = %d, parameterStructure->iAP2DisplayName: %p",    \
                              parameterStructure->iAP2DisplayName_count, parameterStructure->iAP2DisplayName);
        }
        if( (parameterStructure->iAP2Identifier_count < 1) || (parameterStructure->iAP2Identifier_count > 1) || 
            ( (parameterStructure->iAP2Identifier_count != 0) && (parameterStructure->iAP2Identifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Identifier: parameter_count = %d, parameterStructure->iAP2Identifier: %p",    \
                              parameterStructure->iAP2Identifier_count, parameterStructure->iAP2Identifier);
        }
        if( (parameterStructure->iAP2Name_count < 1) || (parameterStructure->iAP2Name_count > 1) || 
            ( (parameterStructure->iAP2Name_count != 0) && (parameterStructure->iAP2Name == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Name: parameter_count = %d, parameterStructure->iAP2Name: %p",    \
                              parameterStructure->iAP2Name_count, parameterStructure->iAP2Name);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2DisplayName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2DisplayName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2EngineType_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_enum, &(parameterStructure->iAP2EngineType[element_loop]), parameterLength, sizeof(U8) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Identifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2Identifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Name_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2Name[element_loop], parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2VehicleStatusComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2VehicleStatusComponent* parameterStructure = (iAP2VehicleStatusComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2Identifier_count < 1) || (parameterStructure->iAP2Identifier_count > 1) || 
            ( (parameterStructure->iAP2Identifier_count != 0) && (parameterStructure->iAP2Identifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Identifier: parameter_count = %d, parameterStructure->iAP2Identifier: %p",    \
                              parameterStructure->iAP2Identifier_count, parameterStructure->iAP2Identifier);
        }
        if(parameterStructure->iAP2InsideTemperature_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2InsideTemperature: parameter_count = %d", parameterStructure->iAP2InsideTemperature_count);
        }
        if( (parameterStructure->iAP2Name_count < 1) || (parameterStructure->iAP2Name_count > 1) || 
            ( (parameterStructure->iAP2Name_count != 0) && (parameterStructure->iAP2Name == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Name: parameter_count = %d, parameterStructure->iAP2Name: %p",    \
                              parameterStructure->iAP2Name_count, parameterStructure->iAP2Name);
        }
        if(parameterStructure->iAP2NightMode_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2NightMode: parameter_count = %d", parameterStructure->iAP2NightMode_count);
        }
        if(parameterStructure->iAP2OutsideTemperature_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2OutsideTemperature: parameter_count = %d", parameterStructure->iAP2OutsideTemperature_count);
        }
        if(parameterStructure->iAP2Range_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2Range: parameter_count = %d", parameterStructure->iAP2Range_count);
        }
        if(parameterStructure->iAP2RangeWarning_count > 1)
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2RangeWarning: parameter_count = %d", parameterStructure->iAP2RangeWarning_count);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Identifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2Identifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2InsideTemperature_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2InsideTemperature is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Name_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2Name[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2NightMode_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2NightMode is Deprecated, dont use it. Kindly refer the Apple specification");
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2OutsideTemperature_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2Range_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2RangeWarning_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}

S32 iAP2CalcLengthiAP2WirelessCarPlayTransportComponent(const void* paramStructure, U16* parameterLength)
{
    S32 rc = IAP2_OK;
    const iAP2WirelessCarPlayTransportComponent* parameterStructure = (iAP2WirelessCarPlayTransportComponent*)paramStructure;

    if(parameterStructure == NULL)
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter");
    }
    else
    {
        U16 element_loop;

        if( (parameterStructure->iAP2TransportComponentIdentifier_count < 1) || (parameterStructure->iAP2TransportComponentIdentifier_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentIdentifier_count != 0) && (parameterStructure->iAP2TransportComponentIdentifier == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentIdentifier: parameter_count = %d, parameterStructure->iAP2TransportComponentIdentifier: %p",    \
                              parameterStructure->iAP2TransportComponentIdentifier_count, parameterStructure->iAP2TransportComponentIdentifier);
        }
        if( (parameterStructure->iAP2TransportComponentName_count < 1) || (parameterStructure->iAP2TransportComponentName_count > 1) || 
            ( (parameterStructure->iAP2TransportComponentName_count != 0) && (parameterStructure->iAP2TransportComponentName == NULL) ) )
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportComponentName: parameter_count = %d, parameterStructure->iAP2TransportComponentName: %p",    \
                              parameterStructure->iAP2TransportComponentName_count, parameterStructure->iAP2TransportComponentName);
        }
        if((parameterStructure->iAP2TransportSupportsCarPlay_count < 1) || (parameterStructure->iAP2TransportSupportsCarPlay_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsCarPlay: parameter_count = %d, parameterStructure->iAP2TransportSupportsCarPlay: %p",    \
                              parameterStructure->iAP2TransportSupportsCarPlay_count, parameterStructure->iAP2TransportSupportsCarPlay);
        }
        if((parameterStructure->iAP2TransportSupportsiAP2Connection_count < 1) || (parameterStructure->iAP2TransportSupportsiAP2Connection_count > 1))
        {
            rc = IAP2_INVALID_PARAMETER_COUNT;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid number of iAP2TransportSupportsiAP2Connection: parameter_count = %d, parameterStructure->iAP2TransportSupportsiAP2Connection: %p",    \
                              parameterStructure->iAP2TransportSupportsiAP2Connection_count, parameterStructure->iAP2TransportSupportsiAP2Connection);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentIdentifier_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_uint16, &(parameterStructure->iAP2TransportComponentIdentifier[element_loop]), parameterLength, sizeof(U16) );
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportComponentName_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_utf8, parameterStructure->iAP2TransportComponentName[element_loop], parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsCarPlay_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
        for(element_loop = 0; ( (element_loop < parameterStructure->iAP2TransportSupportsiAP2Connection_count) && (rc == IAP2_OK) ); element_loop++)
        {
            rc = iAP2CalculateParSpace(iAP2_none, NULL, parameterLength, 0);
        }
    }

    return rc;
}
